/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.util.ArrayList;
import java.util.List;

public class TokenTree {
    private Node root = new Node();
    private Node currentNode;

    public TokenTree() {
        this.root.children = new ArrayList<Node>();
    }

    public void addName(List<String> tokens) {
        Node current = this.root;
        for (String t : tokens) {
            Node next = this.findToken(current, t);
            if (next == null) {
                next = new Node(t, current);
                current.children.add(next);
            }
            current = next;
        }
    }

    public void start(String t) {
        this.currentNode = this.findToken(this.root, t);
    }

    public boolean followUp(String t, boolean commit) {
        if (this.currentNode == null) {
            return false;
        }
        Node node = this.findToken(this.currentNode, t);
        if (commit) {
            this.currentNode = node;
        }
        return node != null;
    }

    private Node findToken(Node current, String t) {
        for (Node n : current.children) {
            if (!n.token.equals(t)) continue;
            return n;
        }
        return null;
    }

    private static class Node {
        public String token;
        public Node parent;
        public List<Node> children;

        public Node() {
            this.children = new ArrayList<Node>();
        }

        public Node(String token, Node parent) {
            this.token = token;
            this.parent = parent;
            this.children = new ArrayList<Node>();
        }
    }
}

