/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileEvaluateTest {
    private static final Logger LOG = LoggerFactory.getLogger(CompileEvaluateTest.class);
    private static final FEEL feel = FEEL.newInstance();

    @Test
    public void test_isDynamicResolution() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("Person List", (Type)BuiltInType.LIST);
        ArrayList errors = new ArrayList();
        FEELEventListener errorsCountingListener = evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                errors.add(evt);
            }
        };
        feel.addListener(errorsCountingListener);
        CompiledExpression compiledExpression = feel.compile("Person List[My Variable 1 = \"A\"]", ctx);
        Assert.assertThat((String)((Object)errors).toString(), (Object)errors.size(), (Matcher)Matchers.is((Object)0));
        HashMap inputs = new HashMap();
        ArrayList pList = new ArrayList();
        inputs.put("Person List", pList);
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Edson Tirelli"), DynamicTypeUtils.entry("My Variable 1", "A")));
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Matteo Mortari"), DynamicTypeUtils.entry("My Variable 1", "B")));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        Assert.assertThat((Object)((List)result), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(((Map)((List)result).get(0)).get("Full Name"), (Matcher)Matchers.is((Object)"Edson Tirelli"));
        feel.removeListener(errorsCountingListener);
    }

    static {
        feel.addListener(evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                LOG.error("{}", (Object)evt);
                if (evt.getSourceException().getCause() != null) {
                    for (Throwable c = evt.getSourceException().getCause(); c != null; c = c.getCause()) {
                        LOG.error(" caused by: {} {}", c.getClass(), (Object)(c.getMessage() != null ? c.getMessage() : ""));
                    }
                    LOG.error(" [stacktraces omitted.]");
                }
            } else if (evt.getSeverity() == FEELEvent.Severity.WARN) {
                LOG.warn("{}", (Object)evt);
            }
        });
    }
}

