/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.io;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.io.ResourceType;

public class ResourceTypeTest {
    @Test
    public void testBPMN2Extension() {
        ResourceType BPMN2 = ResourceType.BPMN2;
        Assertions.assertThat((boolean)BPMN2.matchesExtension("abc.bpmn")).isTrue();
        Assertions.assertThat((boolean)BPMN2.matchesExtension("abc.bpmn2")).isTrue();
        Assertions.assertThat((boolean)BPMN2.matchesExtension("abc.bpmn-cm")).isTrue();
        Assertions.assertThat((boolean)BPMN2.matchesExtension("abc.bpmn2-cm")).isFalse();
    }

    @Test
    public void testGetAllExtensions() throws Exception {
        ResourceType BPMN2 = ResourceType.BPMN2;
        List extensionsBPMN2 = BPMN2.getAllExtensions();
        Assertions.assertThat((int)extensionsBPMN2.size()).isEqualTo(3);
        Assertions.assertThat((boolean)extensionsBPMN2.contains("bpmn")).isTrue();
        Assertions.assertThat((boolean)extensionsBPMN2.contains("bpmn2")).isTrue();
        Assertions.assertThat((boolean)extensionsBPMN2.contains("bpmn-cm")).isTrue();
        Assertions.assertThat((boolean)extensionsBPMN2.contains("bpmn2-cm")).isFalse();
        ResourceType DRL = ResourceType.DRL;
        List extensionsDRL = DRL.getAllExtensions();
        Assertions.assertThat((int)extensionsDRL.size()).isEqualTo(1);
        Assertions.assertThat((boolean)extensionsDRL.contains("drl")).isTrue();
    }

    @Test
    public void testDetermineResourceType() {
        Assertions.assertThat((Object)ResourceType.determineResourceType((String)"test.drl.xls")).isEqualTo((Object)ResourceType.DTABLE);
        Assertions.assertThat((Object)ResourceType.determineResourceType((String)"test.xls")).isNull();
    }
}

