/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api;

import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KModuleXSDTest {
    @Test
    public void loadAndValidate() throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL url = this.getClass().getClassLoader().getResource("org/kie/api/kmodule.xsd");
        Assertions.assertThat((URL)url).isNotNull();
        Schema schema = null;
        try {
            schema = factory.newSchema(url);
        }
        catch (SAXParseException ex) {
            Assertions.fail((String)("Unable to load XSD: " + ex.getMessage() + ":" + ex.getLineNumber() + ":" + ex.getColumnNumber()));
        }
        Assertions.assertThat((Object)schema).isNotNull();
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(KModuleXSDTest.class.getResource("kmod1.xml").openStream());
        Assertions.assertThat((Object)source).isNotNull();
        try {
            validator.validate(source);
        }
        catch (SAXException ex) {
            Assertions.fail((String)("XML should be valid: " + ex.getMessage()));
        }
    }
}

