/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryImpl.class);
    private final String fileName = "kie.conf";
    private final String path = "META-INF/kie.conf";
    private ClassLoader classloader;
    private Map<String, Object> services = new HashMap<String, Object>();
    private Map<String, List<?>> childServices = new HashMap();
    private boolean sealed = false;
    private boolean kiecConfDiscoveryAllowed = true;
    private Map<String, Object> cachedServices = new HashMap<String, Object>();

    private ServiceDiscoveryImpl() {
    }

    public static ServiceDiscoveryImpl getInstance() {
        return LazyHolder.INSTANCE;
    }

    public synchronized boolean isKiecConfDiscoveryAllowed() {
        return this.kiecConfDiscoveryAllowed;
    }

    public synchronized void setKiecConfDiscoveryAllowed(boolean kiecConfDiscoveryAllowed) {
        this.kiecConfDiscoveryAllowed = kiecConfDiscoveryAllowed;
    }

    public <T> void addService(Class<T> serviceClass, T service) {
        this.addService(serviceClass.getCanonicalName(), service);
    }

    public synchronized void addService(String serviceName, Object object) {
        if (this.sealed) {
            throw new IllegalStateException("Unable to add service '" + serviceName + "'. Services cannot be added once the ServiceDiscoverys is sealed");
        }
        this.cachedServices.put(serviceName, object);
    }

    public synchronized void reset() {
        this.cachedServices = new HashMap<String, Object>();
        this.sealed = false;
    }

    public synchronized Map<String, Object> getServices() {
        if (!this.sealed) {
            if (this.kiecConfDiscoveryAllowed) {
                Enumeration<URL> confResources = null;
                try {
                    confResources = this.getClassLoader().getResources("META-INF/kie.conf");
                }
                catch (Exception e) {
                    new IllegalStateException("Discovery started, but no kie.conf's found");
                }
                if (confResources != null) {
                    while (confResources.hasMoreElements()) {
                        this.registerConfs(this.getClassLoader(), confResources.nextElement());
                    }
                }
                this.buildMap();
            }
            this.cachedServices = Collections.unmodifiableMap(this.cachedServices);
            this.sealed = true;
        }
        return this.cachedServices;
    }

    public void registerConfs(ClassLoader classLoader, URL url) {
        log.info("Loading kie.conf from  ", (Object)classLoader);
        Properties props = this.loadConfs(url);
        this.processKieConf(classLoader, props);
    }

    private Properties loadConfs(URL url) {
        Properties props = new Properties();
        try (InputStream is = url.openStream();){
            props.load(is);
            log.info("Discovered kie.conf url={} ", (Object)url);
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to build kie service url = " + url.toExternalForm(), exc);
        }
        return props;
    }

    private void processKieConf(ClassLoader classLoader, Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            boolean optional = key.startsWith("?");
            try {
                this.processKieService(classLoader, optional ? key.substring(1) : key, v.toString());
            }
            catch (RuntimeException e) {
                if (optional) {
                    log.info("Cannot load service: " + key.substring(1));
                }
                throw e;
            }
        }));
    }

    private void processKieService(ClassLoader classLoader, String key, String value) {
        if (value.startsWith("+")) {
            this.childServices.computeIfAbsent(key, k -> new ArrayList()).add(this.newInstance(classLoader, value.substring(1)));
        } else {
            this.services.put(key, this.newInstance(classLoader, value));
        }
        log.info("Adding Service {}\n", (Object)value);
    }

    private <T> T newInstance(ClassLoader classLoader, String className) {
        try {
            return (T)Class.forName(className, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create instance of class: " + className, e);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = Thread.currentThread().getContextClassLoader();
            if (this.classloader == null) {
                this.classloader = ClassLoader.getSystemClassLoader();
            }
        }
        return this.classloader;
    }

    private void buildMap() {
        for (String serviceName : this.services.keySet()) {
            Object service = this.services.get(serviceName);
            this.cachedServices.put(serviceName, service);
            List<?> children = this.childServices.remove(serviceName);
            if (children == null) continue;
            for (Object child : children) {
                ((Consumer)service).accept(child);
            }
        }
        if (!this.childServices.isEmpty()) {
            throw new RuntimeException("Child services " + this.childServices.keySet() + " have no parent");
        }
    }

    @FunctionalInterface
    private static interface ServiceProcessor {
        public boolean process(ClassLoader var1, String var2, String var3);
    }

    private static class LazyHolder {
        static final ServiceDiscoveryImpl INSTANCE = new ServiceDiscoveryImpl();

        private LazyHolder() {
        }
    }
}

