/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.process.svg.SVGImageProcessor;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EvalutionSVGTest {
    private XPath xpath = XPathFactory.newInstance().newXPath();

    @Test
    public void test() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, "#1e90ff");
        this.validateNodesMarkedAsCompleted(svgDocument, completed, "#C0C0C0");
    }

    @Test
    public void testByName() throws Exception {
        ArrayList<String> completedID = new ArrayList<String>();
        completedID.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        ArrayList<String> activeID = new ArrayList<String>();
        activeID.add("_AE5BF0DC-B720-4FDE-9499-5ED89D41FB1A");
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("Self Evaluation");
        ArrayList<String> active = new ArrayList<String>();
        active.add("PM Evaluation");
        String svg = SVGImageProcessor.transformByName((InputStream)EvalutionSVGTest.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, activeID, "#1e90ff");
        this.validateNodesMarkedAsCompleted(svgDocument, completedID, "#C0C0C0");
    }

    @Test
    public void testCompletedAndActive() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        completed.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, "#1e90ff");
        completed.remove("_6063D302-9D81-4C86-920B-E808A45377C2");
        this.validateNodesMarkedAsCompleted(svgDocument, completed, "#C0C0C0");
    }

    @Test
    public void testSubProcessLink() throws Exception {
        ArrayList completed = new ArrayList();
        ArrayList<String> active = new ArrayList<String>();
        active.add("_35262208-8B3E-457E-8D8A-798E70CC280D");
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("_35262208-8B3E-457E-8D8A-798E70CC280D", "http://localhost/processes/1");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/call-activity-svg.svg"), completed, active, links);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, "#1e90ff");
        this.validateCallActivityLinked(svgDocument, active, links);
    }

    @Test
    public void testStunnerSubProcessLink() throws Exception {
        this.testSubProcessLink("_D254259B-8C23-4498-9BE1-995E2DC66726", "/stunner.parentP-svg.svg");
    }

    @Test
    public void testBoundaryEventSubProcessLink() throws Exception {
        this.testSubProcessLink("_86E33F6B-FD3B-4E07-8D60-D273A54FE6B7", "/stunner.parentP.boundaryEvent-svg.svg");
    }

    private void testSubProcessLink(String elementId, String svgFile) throws IOException {
        ArrayList completed = new ArrayList();
        ArrayList<String> active = new ArrayList<String>();
        active.add(elementId);
        HashMap<String, String> links = new HashMap<String, String>();
        links.put(elementId, "http://localhost/processes/1");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream(svgFile), completed, active, links);
        Document svgDocument = this.readSVG(svg);
        Element subprocessPlusIcon = svgDocument.getElementById(elementId + "_subProcessReusableNormalReusableIcon");
        String onclick = subprocessPlusIcon.getAttribute("onclick");
        Assert.assertNotNull((Object)onclick);
        Assert.assertEquals((Object)"window.open('http://localhost/processes/1')", (Object)onclick);
        String style = subprocessPlusIcon.getAttribute("style");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"cursor: pointer;", (Object)style);
    }

    @Test
    public void testCustomColor() throws Exception {
        String completedNodeColor = "#888888";
        String completedNodeBorderColor = "#888887";
        String activeNodeBorderColor = "#888886";
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/evaluation-svg.svg"), completed, active, null, (String)completedNodeColor, (String)completedNodeBorderColor, (String)activeNodeBorderColor, null);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, activeNodeBorderColor);
        this.validateNodesMarkedAsCompleted(svgDocument, completed, completedNodeColor);
    }

    @Test
    public void testViewBoxAttributeAddition() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/evaluation-svg.svg"), completed, active, null, (String)"#888888", (String)"#888887", (String)"#888886", null);
        Document svgDocument = this.readSVG(svg);
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("width"));
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("height"));
        Assert.assertEquals((Object)"0 0 3000 2000", (Object)svgDocument.getFirstChild().getAttributes().getNamedItem("viewBox").getNodeValue());
    }

    private void validateNodesMarkedAsActive(Document svgDocument, List<String> activeNodes, String activeNodeBorderColor) throws XPathExpressionException {
        for (String activeNode : activeNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + activeNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assert.fail((String)("Active element " + activeNode + " not found in the document"));
            }
            String svgId = element.getAttribute("id");
            Element border = svgDocument.getElementById(svgId + "bg_frame");
            String marker = border.getAttribute("stroke");
            Assert.assertNotNull((Object)marker);
            Assert.assertEquals((Object)activeNodeBorderColor, (Object)marker);
            String markerWidth = border.getAttribute("stroke-width");
            Assert.assertNotNull((Object)markerWidth);
            Assert.assertEquals((Object)"2", (Object)markerWidth);
        }
    }

    private void validateNodesMarkedAsCompleted(Document svgDocument, List<String> completedNodes, String completedNodeColor) throws XPathExpressionException {
        for (String completedNode : completedNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + completedNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assert.fail((String)("Completed element " + completedNode + " not found in the document"));
            }
            String svgId = element.getAttribute("id");
            Element background = svgDocument.getElementById(svgId + "fill_el");
            String marker = background.getAttribute("stop-color");
            Assert.assertNotNull((Object)marker);
            Assert.assertEquals((Object)completedNodeColor, (Object)marker);
        }
    }

    private void validateCallActivityLinked(Document svgDocument, List<String> activeNodes, Map<String, String> links) throws XPathExpressionException {
        for (String activeNode : activeNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + activeNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assert.fail((String)("Active element " + activeNode + " not found in the document"));
            }
            String svgId = element.getAttribute("id");
            Element border = svgDocument.getElementById(svgId + "pimg");
            String onclick = border.getAttribute("onclick");
            Assert.assertNotNull((Object)onclick);
            Assert.assertEquals((Object)"", (Object)onclick);
            String link = border.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            Assert.assertNotNull((Object)link);
            Assert.assertEquals((Object)links.get(activeNode), (Object)link);
            String target = border.getAttribute("target");
            Assert.assertNotNull((Object)target);
            Assert.assertEquals((Object)"_blank", (Object)target);
        }
    }

    private Document readSVG(String svgContent) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        factory.setValidating(false);
        Document svgDocument = factory.createDocument("http://jbpm.org", (Reader)new StringReader(svgContent));
        return svgDocument;
    }

    @Test
    public void testRenderBadges() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        String completedNodeId = "_FCDCAA8D-378C-4ADF-9A8C-053FF7363D67";
        completed.add(completedNodeId);
        ArrayList<String> active = new ArrayList<String>();
        String activeNodeId = "_D254259B-8C23-4498-9BE1-995E2DC66726";
        active.add(activeNodeId);
        HashMap<String, Long> nodeBadges = new HashMap<String, Long>();
        nodeBadges.put(completedNodeId, 1L);
        nodeBadges.put(activeNodeId, 1L);
        String svg = SVGImageProcessor.transform((InputStream)EvalutionSVGTest.class.getResourceAsStream("/stunner.parentP-svg.svg"), completed, active, null, (String)"#030303", (String)"#C0C0C0", (String)"#1e90ff", nodeBadges);
        Document svgDocument = this.readSVG(svg);
        Element completedNode = svgDocument.getElementById(completedNodeId);
        this.assertNodeBadgesofNode(completedNode, completedNodeId);
        Element activeNode = svgDocument.getElementById(activeNodeId);
        this.assertNodeBadgesofNode(activeNode, activeNodeId);
    }

    private void assertNodeBadgesofNode(Element completedNode, String targetNode) {
        Node nodeIdNode = completedNode.getAttributes().getNamedItem("bpmn2nodeid");
        Assert.assertNotNull((Object)nodeIdNode);
        NodeList nodeList = completedNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodeBadgeNode = nodeList.item(i).getAttributes().getNamedItem("jbpm-node-badge");
            if (nodeBadgeNode != null) {
                Assert.assertEquals((Object)targetNode, (Object)nodeBadgeNode.getNodeValue());
                Node rectNode = nodeList.item(i).getChildNodes().item(0);
                Assert.assertNotNull((Object)rectNode);
                Node textNode = nodeList.item(i).getChildNodes().item(1);
                Assert.assertNotNull((Object)textNode);
                Assert.assertEquals((Object)"1", (Object)textNode.getFirstChild().getNodeValue());
                continue;
            }
            Node idNode = nodeList.item(i).getAttributes().getNamedItem("id");
            if (idNode == null || !targetNode.equals(idNode.getNodeValue())) continue;
            Assert.assertTrue((boolean)false);
        }
    }
}

