/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.project.backend.server.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.drools.core.util.AbstractXStreamConverter;
import org.kie.guvnor.project.model.QualifierModel;
import org.kie.guvnor.project.model.WorkItemHandlerModel;

public class WorkItemHandelerConverter
extends AbstractXStreamConverter {
    public WorkItemHandelerConverter() {
        super(WorkItemHandlerModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        WorkItemHandlerModel wih = (WorkItemHandlerModel)value;
        writer.addAttribute("type", wih.getType());
        QualifierModel qualifier = wih.getQualifierModel();
        if (qualifier != null) {
            if (qualifier.isSimple()) {
                writer.addAttribute("qualifier", qualifier.getType());
            } else {
                this.writeObject(writer, context, "qualifier", qualifier);
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        final WorkItemHandlerModel wih = new WorkItemHandlerModel();
        wih.setType(reader.getAttribute("type"));
        String qualifierType = reader.getAttribute("qualifier");
        if (qualifierType != null) {
            wih.newQualifierModel(qualifierType);
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("qualifier".equals(name)) {
                    QualifierModel qualifier = (QualifierModel)WorkItemHandelerConverter.this.readObject(reader, context, QualifierModel.class);
                    wih.setQualifierModel(qualifier);
                }
            }
        });
        return wih;
    }
}

