/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.project.backend.server.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.drools.core.util.AbstractXStreamConverter;
import org.kie.guvnor.project.model.ListenerModel;
import org.kie.guvnor.project.model.QualifierModel;

public class ListenerConverter
extends AbstractXStreamConverter {
    public ListenerConverter() {
        super(ListenerModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        ListenerModel listener = (ListenerModel)value;
        writer.addAttribute("type", listener.getType());
        QualifierModel qualifier = listener.getQualifierModel();
        if (qualifier != null) {
            if (qualifier.isSimple()) {
                writer.addAttribute("qualifier", qualifier.getType());
            } else {
                this.writeObject(writer, context, "qualifier", qualifier);
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        final ListenerModel listener = new ListenerModel();
        listener.setType(reader.getAttribute("type"));
        String qualifierType = reader.getAttribute("qualifier");
        if (qualifierType != null) {
            listener.newQualifierModel(qualifierType);
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("qualifier".equals(name)) {
                    QualifierModel qualifier = (QualifierModel)ListenerConverter.this.readObject(reader, context, QualifierModel.class);
                    listener.setQualifierModel(qualifier);
                }
            }
        });
        return listener;
    }
}

