/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.project.backend.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.guvnor.commons.data.workingset.WorkingSetSettings;
import org.kie.guvnor.datamodel.events.InvalidateDMOProjectCacheEvent;
import org.kie.guvnor.project.backend.server.PackageConfigurationContentHandler;
import org.kie.guvnor.project.model.PackageConfiguration;
import org.kie.guvnor.project.service.KModuleService;
import org.kie.guvnor.project.service.POMService;
import org.kie.guvnor.project.service.ProjectService;
import org.kie.guvnor.services.metadata.MetadataService;
import org.kie.guvnor.services.metadata.model.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.client.workbench.widgets.events.ResourceAddedEvent;
import org.uberfire.client.workbench.widgets.events.ResourceUpdatedEvent;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class ProjectServiceImpl
implements ProjectService {
    private static final String SOURCE_FILENAME = "src";
    private static final String POM_PATH = "pom.xml";
    private static final String KMODULE_PATH = "src/main/resources/META-INF/kmodule.xml";
    private static final String SOURCE_JAVA_PATH = "src/main/java";
    private static final String SOURCE_RESOURCES_PATH = "src/main/resources";
    private static final String TEST_JAVA_PATH = "src/test/java";
    private static final String TEST_RESOURCES_PATH = "src/test/resources";
    private IOService ioService;
    private Paths paths;
    private POMService pomService;
    private KModuleService kModuleService;
    private MetadataService metadataService;
    private PackageConfigurationContentHandler packageConfigurationContentHandler;
    private Event<ResourceAddedEvent> resourceAddedEvent;
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    private Identity identity;

    public ProjectServiceImpl() {
    }

    @Inject
    public ProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, Paths paths, POMService pomService, KModuleService kModuleService, MetadataService metadataService, PackageConfigurationContentHandler packageConfigurationContentHandler, Event<ResourceAddedEvent> resourceAddedEvent, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache, Identity identity) {
        this.ioService = ioService;
        this.paths = paths;
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.metadataService = metadataService;
        this.packageConfigurationContentHandler = packageConfigurationContentHandler;
        this.resourceAddedEvent = resourceAddedEvent;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.invalidateDMOProjectCache = invalidateDMOProjectCache;
        this.identity = identity;
    }

    public WorkingSetSettings loadWorkingSetConfig(org.uberfire.backend.vfs.Path project) {
        return new WorkingSetSettings();
    }

    public org.uberfire.backend.vfs.Path resolveProject(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return null;
        }
        Path path = this.paths.convert(resource).normalize();
        if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            path = path.getParent();
        }
        if (this.hasPom(path) && this.hasKModule(path)) {
            return this.paths.convert(path);
        }
        while (path.getNameCount() > 0 && !path.getFileName().toString().equals(SOURCE_FILENAME)) {
            path = path.getParent();
        }
        if (path.getNameCount() == 0) {
            return null;
        }
        if ((path = path.getParent()).getNameCount() == 0 || path == null) {
            return null;
        }
        if (!this.hasPom(path)) {
            return null;
        }
        if (!this.hasKModule(path)) {
            return null;
        }
        return this.paths.convert(path);
    }

    public org.uberfire.backend.vfs.Path resolvePathToPom(org.uberfire.backend.vfs.Path resource) {
        org.uberfire.backend.vfs.Path projectPath = this.resolveProject(resource);
        if (projectPath == null) {
            return null;
        }
        Path pom = this.paths.convert(projectPath).resolve(POM_PATH);
        if (pom == null) {
            return null;
        }
        return this.paths.convert(pom);
    }

    public org.uberfire.backend.vfs.Path resolvePackage(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectRoot = this.resolveProject(resource);
        if (projectRoot == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path packagePath = this.doResolveSrcPackage(resource, projectRoot);
        if (packagePath == null) {
            packagePath = this.doResolveTestPackage(resource, projectRoot);
        }
        return packagePath;
    }

    public org.uberfire.backend.vfs.Path resolveSrcPackage(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectRoot = this.resolveProject(resource);
        if (projectRoot == null) {
            return null;
        }
        return this.doResolveSrcPackage(resource, projectRoot);
    }

    private org.uberfire.backend.vfs.Path doResolveSrcPackage(org.uberfire.backend.vfs.Path resource, org.uberfire.backend.vfs.Path projectRoot) {
        if (this.isPom(resource) || this.isKModule(resource)) {
            return null;
        }
        boolean resolved = false;
        Path path = this.paths.convert(resource).normalize();
        Path srcJavaPath = this.paths.convert(projectRoot).resolve(SOURCE_JAVA_PATH);
        Path srcResourcesPath = this.paths.convert(projectRoot).resolve(SOURCE_RESOURCES_PATH);
        if (path.startsWith(srcJavaPath)) {
            resolved = true;
        } else if (path.startsWith(srcResourcesPath)) {
            resolved = true;
        }
        if (!resolved) {
            return null;
        }
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            return resource;
        }
        path = path.getParent();
        return this.paths.convert(path);
    }

    public org.uberfire.backend.vfs.Path resolveTestPackage(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectRoot = this.resolveProject(resource);
        if (projectRoot == null) {
            return null;
        }
        return this.doResolveTestPackage(resource, projectRoot);
    }

    private org.uberfire.backend.vfs.Path doResolveTestPackage(org.uberfire.backend.vfs.Path resource, org.uberfire.backend.vfs.Path projectRoot) {
        if (this.isPom(resource) || this.isKModule(resource)) {
            return null;
        }
        boolean resolved = false;
        Path path = this.paths.convert(resource).normalize();
        Path testJavaPath = this.paths.convert(projectRoot).resolve(TEST_JAVA_PATH);
        Path testResourcesPath = this.paths.convert(projectRoot).resolve(TEST_RESOURCES_PATH);
        if (path.startsWith(testJavaPath)) {
            resolved = true;
        } else if (path.startsWith(testResourcesPath)) {
            resolved = true;
        }
        if (!resolved) {
            return null;
        }
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            return resource;
        }
        path = path.getParent();
        return this.paths.convert(path);
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return false;
        }
        org.uberfire.backend.vfs.Path projectRoot = this.resolveProject(resource);
        Path path = this.paths.convert(resource).normalize();
        Path pomFilePath = this.paths.convert(projectRoot).resolve(POM_PATH);
        return path.startsWith(pomFilePath);
    }

    public boolean isKModule(org.uberfire.backend.vfs.Path resource) {
        if (resource == null) {
            return false;
        }
        org.uberfire.backend.vfs.Path projectRoot = this.resolveProject(resource);
        Path path = this.paths.convert(resource).normalize();
        Path kmoduleFilePath = this.paths.convert(projectRoot).resolve(KMODULE_PATH);
        return path.startsWith(kmoduleFilePath);
    }

    public String resolvePackageName(org.uberfire.backend.vfs.Path path) {
        Path nioPackagePath;
        org.uberfire.backend.vfs.Path packagePath = this.resolvePackage(path);
        if (packagePath == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectPath = this.resolveProject(packagePath);
        if (projectPath == null) {
            return null;
        }
        Path nioProjectPath = this.paths.convert(projectPath);
        Path nioDelta = nioProjectPath.relativize(nioPackagePath = this.paths.convert(packagePath));
        String packageName = nioDelta.toString();
        if (packageName.startsWith(SOURCE_JAVA_PATH)) {
            packageName = packageName.replace(SOURCE_JAVA_PATH, "");
        } else if (packageName.startsWith(SOURCE_RESOURCES_PATH)) {
            packageName = packageName.replace(SOURCE_RESOURCES_PATH, "");
        } else if (packageName.startsWith(TEST_JAVA_PATH)) {
            packageName = packageName.replace(TEST_JAVA_PATH, "");
        } else if (packageName.startsWith(TEST_RESOURCES_PATH)) {
            packageName = packageName.replace(TEST_RESOURCES_PATH, "");
        }
        if (packageName.startsWith("/")) {
            packageName = packageName.substring(1);
        }
        if (packageName.equals("")) {
            return "defaultpkg";
        }
        return packageName.replaceAll("/", ".");
    }

    public org.uberfire.backend.vfs.Path newProject(org.uberfire.backend.vfs.Path activePath, String projectName, String baseURL) {
        org.uberfire.backend.vfs.Path fsRoot = this.getFileSystemRoot(activePath);
        org.uberfire.backend.vfs.Path projectRootPath = this.getProjectRootPath(fsRoot, projectName);
        this.kModuleService.setUpKModuleStructure(projectRootPath);
        this.pomService.create(projectRootPath, baseURL);
        org.uberfire.backend.vfs.Path projectConfigPath = this.paths.convert(this.paths.convert(projectRootPath).resolve("project.imports"), false);
        this.ioService.createFile(this.paths.convert(projectConfigPath), new FileAttribute[0]);
        this.ioService.write(this.paths.convert(projectConfigPath), this.packageConfigurationContentHandler.toString(new PackageConfiguration()), new OpenOption[0]);
        this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(projectRootPath));
        return this.paths.convert(this.paths.convert(projectRootPath).resolve(POM_PATH));
    }

    private org.uberfire.backend.vfs.Path getFileSystemRoot(org.uberfire.backend.vfs.Path activePath) {
        return this.paths.convert(this.paths.convert(activePath).getRoot(), false);
    }

    private org.uberfire.backend.vfs.Path getProjectRootPath(org.uberfire.backend.vfs.Path fsRoot, String projectName) {
        return this.paths.convert(this.paths.convert(fsRoot).resolve(projectName), false);
    }

    public org.uberfire.backend.vfs.Path newPackage(org.uberfire.backend.vfs.Path contextPath, String packageName) {
        return this.newDirectory(contextPath, packageName);
    }

    public org.uberfire.backend.vfs.Path newDirectory(org.uberfire.backend.vfs.Path contextPath, String dirName) {
        org.uberfire.backend.vfs.Path directoryPath = this.paths.convert(this.ioService.createDirectory(this.paths.convert(contextPath).resolve(dirName), new FileAttribute[0]));
        this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(directoryPath));
        return directoryPath;
    }

    private boolean hasPom(Path path) {
        Path pomPath = path.resolve(POM_PATH);
        return Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0]);
    }

    private boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve(KMODULE_PATH);
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }

    public PackageConfiguration load(org.uberfire.backend.vfs.Path path) {
        String content = this.ioService.readAllString(this.paths.convert(path));
        return this.packageConfigurationContentHandler.toModel(content);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, PackageConfiguration packageConfiguration, Metadata metadata, String comment) {
        this.ioService.write(this.paths.convert(resource), this.packageConfigurationContentHandler.toString(packageConfiguration), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
        this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(resource));
        this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource));
        return resource;
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

