/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.project.backend.server;

import java.io.IOException;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.guvnor.datamodel.events.InvalidateDMOProjectCacheEvent;
import org.kie.guvnor.m2repo.service.M2RepoService;
import org.kie.guvnor.project.backend.server.POMContentHandler;
import org.kie.guvnor.project.model.POM;
import org.kie.guvnor.project.model.Repository;
import org.kie.guvnor.project.service.POMService;
import org.kie.guvnor.services.metadata.MetadataService;
import org.kie.guvnor.services.metadata.model.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.client.workbench.widgets.events.ResourceUpdatedEvent;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class POMServiceImpl
implements POMService {
    private IOService ioService;
    private Paths paths;
    private POMContentHandler pomContentHandler;
    private M2RepoService m2RepoService;
    private MetadataService metadataService;
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    private Identity identity;

    public POMServiceImpl() {
    }

    @Inject
    public POMServiceImpl(@Named(value="ioStrategy") IOService ioService, Paths paths, POMContentHandler pomContentHandler, M2RepoService m2RepoService, MetadataService metadataService, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache, Identity identity) {
        this.ioService = ioService;
        this.paths = paths;
        this.pomContentHandler = pomContentHandler;
        this.m2RepoService = m2RepoService;
        this.metadataService = metadataService;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.invalidateDMOProjectCache = invalidateDMOProjectCache;
        this.identity = identity;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path projectRoot, String baseURL) {
        Path pathToPOMXML = null;
        try {
            POM pomModel = new POM();
            Repository repository = new Repository();
            repository.setId("guvnor-m2-repo");
            repository.setName("Guvnor M2 Repo");
            repository.setUrl(this.m2RepoService.getRepositoryURL(baseURL));
            pomModel.addRepository(repository);
            Path nioRoot = this.paths.convert(projectRoot);
            pathToPOMXML = nioRoot.resolve("pom.xml");
            this.ioService.createFile(pathToPOMXML, new FileAttribute[0]);
            this.ioService.write(pathToPOMXML, this.pomContentHandler.toString(pomModel), new OpenOption[0]);
            return this.paths.convert(pathToPOMXML);
        }
        catch (IOException e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
    }

    public POM load(org.uberfire.backend.vfs.Path path) {
        try {
            Path nioPath = this.paths.convert(path);
            String content = this.ioService.readAllString(nioPath);
            return this.pomContentHandler.toModel(content);
        }
        catch (IOException e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
        catch (XmlPullParserException e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment) {
        try {
            if (metadata == null) {
                this.ioService.write(this.paths.convert(path), this.pomContentHandler.toString(content), new OpenOption[]{this.makeCommentedOption(comment)});
            } else {
                this.ioService.write(this.paths.convert(path), this.pomContentHandler.toString(content), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            }
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(path));
            return path;
        }
        catch (IOException e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

