/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.project.backend.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.kie.guvnor.project.backend.server.converters.ClockTypeConverter;
import org.kie.guvnor.project.backend.server.converters.KBaseConverter;
import org.kie.guvnor.project.backend.server.converters.KModuleConverter;
import org.kie.guvnor.project.backend.server.converters.KSessionConverter;
import org.kie.guvnor.project.backend.server.converters.ListenerConverter;
import org.kie.guvnor.project.backend.server.converters.QualifierConverter;
import org.kie.guvnor.project.backend.server.converters.WorkItemHandelerConverter;
import org.kie.guvnor.project.model.ClockTypeOption;
import org.kie.guvnor.project.model.KBaseModel;
import org.kie.guvnor.project.model.KModuleModel;
import org.kie.guvnor.project.model.KSessionModel;
import org.kie.guvnor.project.model.ListenerModel;
import org.kie.guvnor.project.model.QualifierModel;
import org.kie.guvnor.project.model.WorkItemHandlerModel;

public class KModuleContentHandler {
    public KModuleModel toModel(String xml) {
        return (KModuleModel)this.createXStream().fromXML(xml);
    }

    public String toString(KModuleModel model) {
        return this.createXStream().toXML((Object)model);
    }

    private XStream createXStream() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.registerConverter((Converter)new KModuleConverter());
        xStream.registerConverter((Converter)new KBaseConverter());
        xStream.registerConverter((Converter)new KSessionConverter());
        xStream.registerConverter((Converter)new ClockTypeConverter());
        xStream.registerConverter((Converter)new ListenerConverter());
        xStream.registerConverter((Converter)new QualifierConverter());
        xStream.registerConverter((Converter)new WorkItemHandelerConverter());
        xStream.alias("kmodule", KModuleModel.class);
        xStream.alias("kbase", KBaseModel.class);
        xStream.alias("ksession", KSessionModel.class);
        xStream.alias("clockType", ClockTypeOption.class);
        xStream.alias("listener", ListenerModel.class);
        xStream.alias("qualifier", QualifierModel.class);
        xStream.alias("workItemHandler", WorkItemHandlerModel.class);
        return xStream;
    }
}

