/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.identifiers.ReflectiveAppRoot;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.MemoryFileUtils;
import org.kie.efesto.common.core.identifiers.componentroots.ComponentFoo;
import org.kie.efesto.common.core.identifiers.componentroots.ComponentRootB;
import org.kie.efesto.common.core.utils.JSONUtils;

class JSONUtilsTest {
    JSONUtilsTest() {
    }

    @Test
    void getGeneratedResourceString() throws JsonProcessingException {
        String fullClassName = "full.class.Name";
        GeneratedClassResource generatedResource = new GeneratedClassResource(fullClassName);
        String expected = String.format("{\"step-type\":\"class\",\"fullClassName\":\"%s\"}", fullClassName);
        String retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        LocalUri modelLocalUriId = ((ComponentFoo)new ReflectiveAppRoot("test").get(ComponentFoo.class)).get("this", "is", "modelLocalUriId").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        String target = "foo";
        generatedResource = new GeneratedRedirectResource(localUriId, target);
        expected = String.format("{\"step-type\":\"redirect\",\"modelLocalUriId\":%s,\"target\":\"%s\"}", JSONUtils.getModelLocalUriIdString((ModelLocalUriId)localUriId), target);
        retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        generatedResource = new GeneratedExecutableResource(localUriId, Collections.singletonList(fullClassName));
        expected = String.format("{\"step-type\":\"executable\",\"modelLocalUriId\":%s,\"fullClassNames\":[\"%s\"]}", JSONUtils.getModelLocalUriIdString((ModelLocalUriId)localUriId), fullClassName);
        retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void getGeneratedResourceObject() throws JsonProcessingException {
        String generatedResourceString = "{\"step-type\":\"redirect\",\"modelLocalUriId\":{\"model\":\"this\",\"basePath\":\"/is/fri_foo\",\"fullPath\":\"/this/is/fri_foo\"},\"target\":\"foo\"}";
        GeneratedResource retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedRedirectResource.class);
        generatedResourceString = "{\"step-type\":\"class\",\"fullClassName\":\"full.class.Name\"}\"";
        retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedClassResource.class);
        generatedResourceString = "{\"step-type\":\"executable\",\"modelLocalUriId\":{\"model\":\"this\",\"basePath\":\"/this/is/fri_foo\",\"fullPath\":\"/this/is/fri_foo\"},\"fullClassNames\":[\"full.class.Name\"]}";
        retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedExecutableResource.class);
    }

    @Test
    void getGeneratedResourcesString() throws JsonProcessingException {
        String fullClassName = "full.class.Name";
        GeneratedClassResource generatedIntermediateResource = new GeneratedClassResource(fullClassName);
        String model = "foo";
        LocalUri modelLocalUriId = ((ComponentRootB)new ReflectiveAppRoot(model).get(ComponentRootB.class)).get("this", "is", "modelLocalUriId").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        GeneratedExecutableResource generatedFinalResource = new GeneratedExecutableResource(localUriId, Collections.singletonList(fullClassName));
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)generatedIntermediateResource);
        generatedResources.add((Object)generatedFinalResource);
        String retrieved = JSONUtils.getGeneratedResourcesString((GeneratedResources)generatedResources);
        String expected1 = String.format("{\"step-type\":\"class\",\"fullClassName\":\"%s\"}", fullClassName);
        String expected2 = String.format("{\"step-type\":\"executable\",\"modelLocalUriId\":%s,\"fullClassNames\":[\"%s\"]}", JSONUtils.getModelLocalUriIdString((ModelLocalUriId)localUriId), fullClassName);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected1});
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromString() throws JsonProcessingException {
        String generatedResourcesString = "[{\"step-type\":\"executable\",\"modelLocalUriId\":{\"model\":\"foo\",\"basePath\":\"/this/is/fri\",\"fullPath\":\"/foo/this/is/fri\"}},{\"step-type\":\"class\",\"fullClassName\":\"full.class.Name\"}]";
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((String)generatedResourcesString);
        Assertions.assertThat((Collection)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        LocalUri modelLocalUriId = ((ComponentFoo)new ReflectiveAppRoot("test").get(ComponentFoo.class)).get("this", "is", "fri").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(localUriId, Collections.singletonList(fullClassName));
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromFile() throws Exception {
        String fileName = "IndexFile.test_json";
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        assert (resource != null);
        IndexFile indexFile = new IndexFile(new File(resource.toURI()));
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
        Assertions.assertThat((Collection)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        LocalUri modelLocalUriId = ((ComponentFoo)new ReflectiveAppRoot("test").get(ComponentFoo.class)).get("this", "is", "fri").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(localUriId, Collections.singletonList(fullClassName));
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromJar() throws Exception {
        ClassLoader originalClassLoader = this.addJarToClassLoader();
        Optional optionalIndexFile = MemoryFileUtils.getFileFromFileName((String)"IndexFile.testb_json");
        ((OptionalAssert)Assertions.assertThat((Optional)optionalIndexFile).isNotNull()).isPresent();
        Assertions.assertThat((Optional)optionalIndexFile).get().isInstanceOf(MemoryFile.class);
        MemoryFile memoryFile = (MemoryFile)optionalIndexFile.get();
        IndexFile indexFile = new IndexFile((MemoryFile)optionalIndexFile.get());
        Assertions.assertThat((byte[])indexFile.getContent()).isEqualTo((Object)memoryFile.getContent());
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
        Assertions.assertThat((Collection)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        LocalUri modelLocalUriId = ((ComponentFoo)new ReflectiveAppRoot("test").get(ComponentFoo.class)).get("this", "is", "fri").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(localUriId, Collections.singletonList(fullClassName));
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Collection)retrieved).contains((Object[])new GeneratedResource[]{expected2});
        this.restoreClassLoader(originalClassLoader);
    }

    @Test
    void getModelLocalUriIdString() throws JsonProcessingException {
        String model = "foo";
        String basePath = "this/is/modelLocalUriId";
        LocalUri modelLocalUriId = ((ComponentFoo)new ReflectiveAppRoot("test").get(ComponentFoo.class)).get("this", "is", "modelLocalUriId").asLocalUri();
        ModelLocalUriId localUriId = new ModelLocalUriId(modelLocalUriId);
        String retrieved = JSONUtils.getModelLocalUriIdString((ModelLocalUriId)localUriId);
        String expected = String.format("{\"model\":\"%1$s\",\"basePath\":\"/%2$s\",\"fullPath\":\"/%1$s/%2$s\"}", model, basePath);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void getModelLocalUriIdObject() throws JsonProcessingException {
        String localUriIdString = "{\"model\":\"foo\",\"basePath\":\"/this/is/modelLocalUriId\",\"fullPath\":\"/foo/this/is/modelLocalUriId\"}";
        ModelLocalUriId retrieved = JSONUtils.getModelLocalUriIdObject((String)localUriIdString);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    private ClassLoader addJarToClassLoader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        URL jarUrl = Thread.currentThread().getContextClassLoader().getResource("TestJar.jar");
        Assertions.assertThat((URL)jarUrl).isNotNull();
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource("IndexFile.testb_json");
        Assertions.assertThat((URL)fileUrl).isNull();
        URL[] urls = new URL[]{jarUrl};
        URLClassLoader testClassLoader = URLClassLoader.newInstance(urls, originalClassLoader);
        Thread.currentThread().setContextClassLoader(testClassLoader);
        return originalClassLoader;
    }

    private void restoreClassLoader(ClassLoader toRestore) {
        Thread.currentThread().setContextClassLoader(toRestore);
    }
}

