/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.core.serialization.ModelLocalUriIdDeSerializer;

class ModelLocalUriIdDeSerializerTest {
    ModelLocalUriIdDeSerializerTest() {
    }

    @Test
    void deserializeDecodedPath() throws IOException {
        String json = "{\"model\":\"example\",\"basePath\":\"/some-id/instances/some-instance-id\",\"fullPath\":\"/example/some-id/instances/some-instance-id\"}";
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonParser parser = mapper.getFactory().createParser((InputStream)stream);
        DeserializationContext ctxt = mapper.getDeserializationContext();
        ModelLocalUriId retrieved = new ModelLocalUriIdDeSerializer().deserialize(parser, ctxt);
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId expected = new ModelLocalUriId(parsed);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void deserializeEncodedPath() throws IOException {
        String json = "{\"model\":\"To%2Bdecode%2Bfirst%2Bpart\",\"basePath\":\"/To+decode+second+part/To+decode+third+part\",\"fullPath\":\"/To+decode+first+part/To+decode+second+part/To+decode+third+part\"}";
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonParser parser = mapper.getFactory().createParser((InputStream)stream);
        DeserializationContext ctxt = mapper.getDeserializationContext();
        ModelLocalUriId retrieved = new ModelLocalUriIdDeSerializer().deserialize(parser, ctxt);
        String path = "/To+decode+first+part/To+decode+second+part/To+decode+third+part/";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId expected = new ModelLocalUriId(parsed);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }
}

