/*
 * Decompiled with CFR 0.152.
 */
package org.mwg;

import java.io.File;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.mwg.Callback;
import org.mwg.Graph;
import org.mwg.plugin.Base64;
import org.mwg.plugin.Storage;
import org.mwg.struct.Buffer;
import org.mwg.struct.BufferIterator;

public class LevelDBStorage
implements Storage {
    private static final String _connectedError = "PLEASE CONNECT YOUR DATABASE FIRST";
    private static final byte[] prefixKey = "prefix".getBytes();
    private final String storagePath;
    private DB db;
    private boolean isConnected = false;
    private Graph graph;
    private boolean useNative = true;

    public LevelDBStorage(String storagePath) {
        this.storagePath = storagePath;
    }

    public LevelDBStorage useNative(boolean p_useNative) {
        this.useNative = p_useNative;
        return this;
    }

    public void get(Buffer keys, Callback<Buffer> callback) {
        if (!this.isConnected) {
            throw new RuntimeException(_connectedError);
        }
        Buffer result = this.graph.newBuffer();
        BufferIterator it = keys.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Buffer view = it.next();
            try {
                byte[] res;
                if (!isFirst) {
                    result.write((byte)35);
                } else {
                    isFirst = false;
                }
                if ((res = this.db.get(view.data())) == null) continue;
                result.writeAll(res);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (callback != null) {
            callback.on((Object)result);
        }
    }

    public void put(Buffer stream, Callback<Boolean> callback) {
        block5: {
            if (!this.isConnected) {
                throw new RuntimeException(_connectedError);
            }
            try {
                WriteBatch batch = this.db.createWriteBatch();
                BufferIterator it = stream.iterator();
                while (it.hasNext()) {
                    Buffer keyView = it.next();
                    Buffer valueView = it.next();
                    if (valueView == null) continue;
                    batch.put(keyView.data(), valueView.data());
                }
                this.db.write(batch);
                if (callback != null) {
                    callback.on((Object)true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block5;
                callback.on((Object)false);
            }
        }
    }

    public void remove(Buffer keys, Callback<Boolean> callback) {
        block5: {
            if (!this.isConnected) {
                throw new RuntimeException(_connectedError);
            }
            try {
                for (Buffer view : keys) {
                    this.db.delete(view.data());
                }
                if (callback != null) {
                    callback.on(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block5;
                callback.on((Object)false);
            }
        }
    }

    public void disconnect(Callback<Boolean> callback) {
        block3: {
            try {
                this.db.close();
                this.db = null;
                if (callback != null) {
                    callback.on((Object)true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block3;
                callback.on((Object)false);
            }
        }
    }

    public void connect(Graph graph, Callback<Boolean> callback) {
        block6: {
            if (this.isConnected) {
                if (callback != null) {
                    callback.on(null);
                }
                return;
            }
            this.graph = graph;
            Options options = new Options().createIfMissing(true).compressionType(CompressionType.SNAPPY);
            File location = new File(this.storagePath);
            if (!location.exists()) {
                location.mkdirs();
            }
            File targetDB = new File(location, "data");
            targetDB.mkdirs();
            try {
                this.db = this.useNative ? JniDBFactory.factory.open(targetDB, options) : Iq80DBFactory.factory.open(targetDB, options);
                this.isConnected = true;
                if (callback != null) {
                    callback.on((Object)true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block6;
                callback.on(null);
            }
        }
    }

    public void lock(Callback<Buffer> callback) {
        if (!this.isConnected) {
            throw new RuntimeException(_connectedError);
        }
        byte[] current = this.db.get(prefixKey);
        if (current == null) {
            current = new String("0").getBytes();
        }
        Short currentPrefix = Short.parseShort(new String(current));
        this.db.put(prefixKey, (currentPrefix + 1 + "").getBytes());
        if (callback != null) {
            Buffer newBuf = this.graph.newBuffer();
            Base64.encodeIntToBuffer((int)currentPrefix.shortValue(), (Buffer)newBuf);
            callback.on((Object)newBuf);
        }
    }

    public void unlock(Buffer previousLock, Callback<Boolean> callback) {
        if (!this.isConnected) {
            throw new RuntimeException(_connectedError);
        }
        callback.on((Object)true);
    }
}

