/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.BinaryRepository;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class BinaryRepositoriesClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("BinaryRepositoriesClient 1.0.0-RC-SNAPSHOT");

    public BinaryRepositoriesClient() {
    }

    public BinaryRepositoriesClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public BinaryRepositoriesClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addBinaryRepositoryCall(BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BinaryRepository localVarPostBody = binaryrepository;
        String localVarPath = "/binaryrepositories";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addBinaryRepositoryValidateBeforeCall(BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (binaryrepository == null) {
            throw new ApiException("Missing the required parameter 'binaryrepository' when calling addBinaryRepository(Async)");
        }
        Call call = this.addBinaryRepositoryCall(binaryrepository, progressListener, progressRequestListener);
        return call;
    }

    public BinaryRepository addBinaryRepository(BinaryRepository binaryrepository) throws ApiException {
        ApiResponse<BinaryRepository> resp = this.addBinaryRepositoryWithHttpInfo(binaryrepository);
        return (BinaryRepository)resp.getData();
    }

    public ApiResponse<BinaryRepository> addBinaryRepositoryWithHttpInfo(BinaryRepository binaryrepository) throws ApiException {
        Call call = this.addBinaryRepositoryValidateBeforeCall(binaryrepository, null, null);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addBinaryRepositoryAsync(BinaryRepository binaryrepository, ApiCallback<BinaryRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addBinaryRepositoryValidateBeforeCall(binaryrepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteBinaryRepositoryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/binaryrepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteBinaryRepositoryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteBinaryRepository(Async)");
        }
        Call call = this.deleteBinaryRepositoryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public String deleteBinaryRepository(String resourceId) throws ApiException {
        ApiResponse<String> resp = this.deleteBinaryRepositoryWithHttpInfo(resourceId);
        return (String)resp.getData();
    }

    public ApiResponse<String> deleteBinaryRepositoryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteBinaryRepositoryValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteBinaryRepositoryAsync(String resourceId, ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteBinaryRepositoryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBinaryRepositoriesCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/binaryrepositories";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBinaryRepositoriesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getBinaryRepositoriesCall(progressListener, progressRequestListener);
        return call;
    }

    public List<BinaryRepository> getBinaryRepositories() throws ApiException {
        ApiResponse<List<BinaryRepository>> resp = this.getBinaryRepositoriesWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<BinaryRepository>> getBinaryRepositoriesWithHttpInfo() throws ApiException {
        Call call = this.getBinaryRepositoriesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<BinaryRepository>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBinaryRepositoriesAsync(ApiCallback<List<BinaryRepository>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getBinaryRepositoriesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<BinaryRepository>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBinaryRepositoryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/binaryrepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBinaryRepositoryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getBinaryRepository(Async)");
        }
        Call call = this.getBinaryRepositoryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public BinaryRepository getBinaryRepository(String resourceId) throws ApiException {
        ApiResponse<BinaryRepository> resp = this.getBinaryRepositoryWithHttpInfo(resourceId);
        return (BinaryRepository)resp.getData();
    }

    public ApiResponse<BinaryRepository> getBinaryRepositoryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getBinaryRepositoryValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBinaryRepositoryAsync(String resourceId, ApiCallback<BinaryRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getBinaryRepositoryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateBinaryRepositoryCall(String resourceId, BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BinaryRepository localVarPostBody = binaryrepository;
        String localVarPath = "/binaryrepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateBinaryRepositoryValidateBeforeCall(String resourceId, BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateBinaryRepository(Async)");
        }
        if (binaryrepository == null) {
            throw new ApiException("Missing the required parameter 'binaryrepository' when calling updateBinaryRepository(Async)");
        }
        Call call = this.updateBinaryRepositoryCall(resourceId, binaryrepository, progressListener, progressRequestListener);
        return call;
    }

    public BinaryRepository updateBinaryRepository(String resourceId, BinaryRepository binaryrepository) throws ApiException {
        ApiResponse<BinaryRepository> resp = this.updateBinaryRepositoryWithHttpInfo(resourceId, binaryrepository);
        return (BinaryRepository)resp.getData();
    }

    public ApiResponse<BinaryRepository> updateBinaryRepositoryWithHttpInfo(String resourceId, BinaryRepository binaryrepository) throws ApiException {
        Call call = this.updateBinaryRepositoryValidateBeforeCall(resourceId, binaryrepository, null, null);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateBinaryRepositoryAsync(String resourceId, BinaryRepository binaryrepository, ApiCallback<BinaryRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateBinaryRepositoryValidateBeforeCall(resourceId, binaryrepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateBinaryRepositoryAttributesCall(String resourceId, BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BinaryRepository localVarPostBody = binaryrepository;
        String localVarPath = "/binaryrepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateBinaryRepositoryAttributesValidateBeforeCall(String resourceId, BinaryRepository binaryrepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateBinaryRepositoryAttributes(Async)");
        }
        if (binaryrepository == null) {
            throw new ApiException("Missing the required parameter 'binaryrepository' when calling updateBinaryRepositoryAttributes(Async)");
        }
        Call call = this.updateBinaryRepositoryAttributesCall(resourceId, binaryrepository, progressListener, progressRequestListener);
        return call;
    }

    public BinaryRepository updateBinaryRepositoryAttributes(String resourceId, BinaryRepository binaryrepository) throws ApiException {
        ApiResponse<BinaryRepository> resp = this.updateBinaryRepositoryAttributesWithHttpInfo(resourceId, binaryrepository);
        return (BinaryRepository)resp.getData();
    }

    public ApiResponse<BinaryRepository> updateBinaryRepositoryAttributesWithHttpInfo(String resourceId, BinaryRepository binaryrepository) throws ApiException {
        Call call = this.updateBinaryRepositoryAttributesValidateBeforeCall(resourceId, binaryrepository, null, null);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateBinaryRepositoryAttributesAsync(String resourceId, BinaryRepository binaryrepository, ApiCallback<BinaryRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateBinaryRepositoryAttributesValidateBeforeCall(resourceId, binaryrepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BinaryRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

