/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.User;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class UsersClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("UsersClient 1.0.0-RC-SNAPSHOT");

    public UsersClient() {
    }

    public UsersClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public UsersClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addUserCall(User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        User localVarPostBody = user;
        String localVarPath = "/users";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addUserValidateBeforeCall(User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling addUser(Async)");
        }
        Call call = this.addUserCall(user, progressListener, progressRequestListener);
        return call;
    }

    public User addUser(User user) throws ApiException {
        ApiResponse<User> resp = this.addUserWithHttpInfo(user);
        return (User)resp.getData();
    }

    public ApiResponse<User> addUserWithHttpInfo(User user) throws ApiException {
        Call call = this.addUserValidateBeforeCall(user, null, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addUserAsync(User user, ApiCallback<User> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addUserValidateBeforeCall(user, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteUserCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteUserValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteUser(Async)");
        }
        Call call = this.deleteUserCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public String deleteUser(String resourceId) throws ApiException {
        ApiResponse<String> resp = this.deleteUserWithHttpInfo(resourceId);
        return (String)resp.getData();
    }

    public ApiResponse<String> deleteUserWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteUserValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteUserAsync(String resourceId, ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteUserValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getUser(Async)");
        }
        Call call = this.getUserCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public User getUser(String resourceId) throws ApiException {
        ApiResponse<User> resp = this.getUserWithHttpInfo(resourceId);
        return (User)resp.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getUserValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserAsync(String resourceId, ApiCallback<User> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getUserValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUsersCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getUsers() throws ApiException {
        ApiResponse<List<User>> resp = this.getUsersWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<User>> getUsersWithHttpInfo() throws ApiException {
        Call call = this.getUsersValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUsersAsync(ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateUserCall(String resourceId, User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        User localVarPostBody = user;
        String localVarPath = "/users/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateUserValidateBeforeCall(String resourceId, User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateUser(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling updateUser(Async)");
        }
        Call call = this.updateUserCall(resourceId, user, progressListener, progressRequestListener);
        return call;
    }

    public User updateUser(String resourceId, User user) throws ApiException {
        ApiResponse<User> resp = this.updateUserWithHttpInfo(resourceId, user);
        return (User)resp.getData();
    }

    public ApiResponse<User> updateUserWithHttpInfo(String resourceId, User user) throws ApiException {
        Call call = this.updateUserValidateBeforeCall(resourceId, user, null, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateUserAsync(String resourceId, User user, ApiCallback<User> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateUserValidateBeforeCall(resourceId, user, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateUserAttributesCall(String resourceId, User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        User localVarPostBody = user;
        String localVarPath = "/users/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateUserAttributesValidateBeforeCall(String resourceId, User user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateUserAttributes(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling updateUserAttributes(Async)");
        }
        Call call = this.updateUserAttributesCall(resourceId, user, progressListener, progressRequestListener);
        return call;
    }

    public User updateUserAttributes(String resourceId, User user) throws ApiException {
        ApiResponse<User> resp = this.updateUserAttributesWithHttpInfo(resourceId, user);
        return (User)resp.getData();
    }

    public ApiResponse<User> updateUserAttributesWithHttpInfo(String resourceId, User user) throws ApiException {
        Call call = this.updateUserAttributesValidateBeforeCall(resourceId, user, null, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateUserAttributesAsync(String resourceId, User user, ApiCallback<User> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateUserAttributesValidateBeforeCall(resourceId, user, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

