/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.Component;
import org.kathra.core.model.Implementation;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class ComponentsClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("ComponentsClient 1.0.0-RC-SNAPSHOT");

    public ComponentsClient() {
    }

    public ComponentsClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public ComponentsClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addComponentCall(Component component, String groupPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Component localVarPostBody = component;
        String localVarPath = "/components";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (groupPath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupPath", (Object)groupPath));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addComponentValidateBeforeCall(Component component, String groupPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (component == null) {
            throw new ApiException("Missing the required parameter 'component' when calling addComponent(Async)");
        }
        if (groupPath == null) {
            throw new ApiException("Missing the required parameter 'groupPath' when calling addComponent(Async)");
        }
        Call call = this.addComponentCall(component, groupPath, progressListener, progressRequestListener);
        return call;
    }

    public Component addComponent(Component component, String groupPath) throws ApiException {
        ApiResponse<Component> resp = this.addComponentWithHttpInfo(component, groupPath);
        return (Component)resp.getData();
    }

    public ApiResponse<Component> addComponentWithHttpInfo(Component component, String groupPath) throws ApiException {
        Call call = this.addComponentValidateBeforeCall(component, groupPath, null, null);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addComponentAsync(Component component, String groupPath, ApiCallback<Component> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addComponentValidateBeforeCall(component, groupPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteComponentCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/components/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteComponentValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteComponent(Async)");
        }
        Call call = this.deleteComponentCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public String deleteComponent(String resourceId) throws ApiException {
        ApiResponse<String> resp = this.deleteComponentWithHttpInfo(resourceId);
        return (String)resp.getData();
    }

    public ApiResponse<String> deleteComponentWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteComponentValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteComponentAsync(String resourceId, ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteComponentValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getComponentCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/components/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getComponentValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getComponent(Async)");
        }
        Call call = this.getComponentCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public Component getComponent(String resourceId) throws ApiException {
        ApiResponse<Component> resp = this.getComponentWithHttpInfo(resourceId);
        return (Component)resp.getData();
    }

    public ApiResponse<Component> getComponentWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getComponentValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getComponentAsync(String resourceId, ApiCallback<Component> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getComponentValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getComponentsCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/components";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getComponentsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getComponentsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<Component> getComponents() throws ApiException {
        ApiResponse<List<Component>> resp = this.getComponentsWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<Component>> getComponentsWithHttpInfo() throws ApiException {
        Call call = this.getComponentsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<Component>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getComponentsAsync(ApiCallback<List<Component>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getComponentsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Component>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getImplementationsComponentCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/components/{resourceId}/implementations".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getImplementationsComponentValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getImplementationsComponent(Async)");
        }
        Call call = this.getImplementationsComponentCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public List<Implementation> getImplementationsComponent(String resourceId) throws ApiException {
        ApiResponse<List<Implementation>> resp = this.getImplementationsComponentWithHttpInfo(resourceId);
        return (List)resp.getData();
    }

    public ApiResponse<List<Implementation>> getImplementationsComponentWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getImplementationsComponentValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<List<Implementation>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getImplementationsComponentAsync(String resourceId, ApiCallback<List<Implementation>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getImplementationsComponentValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Implementation>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateComponentCall(String resourceId, Component component, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Component localVarPostBody = component;
        String localVarPath = "/components/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateComponentValidateBeforeCall(String resourceId, Component component, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateComponent(Async)");
        }
        if (component == null) {
            throw new ApiException("Missing the required parameter 'component' when calling updateComponent(Async)");
        }
        Call call = this.updateComponentCall(resourceId, component, progressListener, progressRequestListener);
        return call;
    }

    public Component updateComponent(String resourceId, Component component) throws ApiException {
        ApiResponse<Component> resp = this.updateComponentWithHttpInfo(resourceId, component);
        return (Component)resp.getData();
    }

    public ApiResponse<Component> updateComponentWithHttpInfo(String resourceId, Component component) throws ApiException {
        Call call = this.updateComponentValidateBeforeCall(resourceId, component, null, null);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateComponentAsync(String resourceId, Component component, ApiCallback<Component> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateComponentValidateBeforeCall(resourceId, component, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateComponentAttributesCall(String resourceId, Component component, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Component localVarPostBody = component;
        String localVarPath = "/components/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateComponentAttributesValidateBeforeCall(String resourceId, Component component, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateComponentAttributes(Async)");
        }
        if (component == null) {
            throw new ApiException("Missing the required parameter 'component' when calling updateComponentAttributes(Async)");
        }
        Call call = this.updateComponentAttributesCall(resourceId, component, progressListener, progressRequestListener);
        return call;
    }

    public Component updateComponentAttributes(String resourceId, Component component) throws ApiException {
        ApiResponse<Component> resp = this.updateComponentAttributesWithHttpInfo(resourceId, component);
        return (Component)resp.getData();
    }

    public ApiResponse<Component> updateComponentAttributesWithHttpInfo(String resourceId, Component component) throws ApiException {
        Call call = this.updateComponentAttributesValidateBeforeCall(resourceId, component, null, null);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateComponentAttributesAsync(String resourceId, Component component, ApiCallback<Component> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateComponentAttributesValidateBeforeCall(resourceId, component, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Component>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

