/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.SourceRepository;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class SourceRepositoriesClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("SourceRepositoriesClient 1.0.0");

    public SourceRepositoriesClient() {
    }

    public SourceRepositoriesClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public SourceRepositoriesClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addSourceRepositoryCall(SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SourceRepository localVarPostBody = sourcerepository;
        String localVarPath = "/sourcerepositories";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addSourceRepositoryValidateBeforeCall(SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourcerepository == null) {
            throw new ApiException("Missing the required parameter 'sourcerepository' when calling addSourceRepository(Async)");
        }
        Call call = this.addSourceRepositoryCall(sourcerepository, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepository addSourceRepository(SourceRepository sourcerepository) throws ApiException {
        ApiResponse<SourceRepository> resp = this.addSourceRepositoryWithHttpInfo(sourcerepository);
        return (SourceRepository)resp.getData();
    }

    public ApiResponse<SourceRepository> addSourceRepositoryWithHttpInfo(SourceRepository sourcerepository) throws ApiException {
        Call call = this.addSourceRepositoryValidateBeforeCall(sourcerepository, null, null);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addSourceRepositoryAsync(SourceRepository sourcerepository, ApiCallback<SourceRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addSourceRepositoryValidateBeforeCall(sourcerepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSourceRepositoryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourcerepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSourceRepositoryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteSourceRepository(Async)");
        }
        Call call = this.deleteSourceRepositoryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteSourceRepository(String resourceId) throws ApiException {
        this.deleteSourceRepositoryWithHttpInfo(resourceId);
    }

    public ApiResponse<Void> deleteSourceRepositoryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteSourceRepositoryValidateBeforeCall(resourceId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSourceRepositoryAsync(String resourceId, ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteSourceRepositoryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getSourceRepositoriesCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourcerepositories";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSourceRepositoriesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSourceRepositoriesCall(progressListener, progressRequestListener);
        return call;
    }

    public List<SourceRepository> getSourceRepositories() throws ApiException {
        ApiResponse<List<SourceRepository>> resp = this.getSourceRepositoriesWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<SourceRepository>> getSourceRepositoriesWithHttpInfo() throws ApiException {
        Call call = this.getSourceRepositoriesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<SourceRepository>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSourceRepositoriesAsync(ApiCallback<List<SourceRepository>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getSourceRepositoriesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<SourceRepository>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSourceRepositoryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourcerepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSourceRepositoryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getSourceRepository(Async)");
        }
        Call call = this.getSourceRepositoryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepository getSourceRepository(String resourceId) throws ApiException {
        ApiResponse<SourceRepository> resp = this.getSourceRepositoryWithHttpInfo(resourceId);
        return (SourceRepository)resp.getData();
    }

    public ApiResponse<SourceRepository> getSourceRepositoryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getSourceRepositoryValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSourceRepositoryAsync(String resourceId, ApiCallback<SourceRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getSourceRepositoryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateSourceRepositoryCall(String resourceId, SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SourceRepository localVarPostBody = sourcerepository;
        String localVarPath = "/sourcerepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSourceRepositoryValidateBeforeCall(String resourceId, SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateSourceRepository(Async)");
        }
        if (sourcerepository == null) {
            throw new ApiException("Missing the required parameter 'sourcerepository' when calling updateSourceRepository(Async)");
        }
        Call call = this.updateSourceRepositoryCall(resourceId, sourcerepository, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepository updateSourceRepository(String resourceId, SourceRepository sourcerepository) throws ApiException {
        ApiResponse<SourceRepository> resp = this.updateSourceRepositoryWithHttpInfo(resourceId, sourcerepository);
        return (SourceRepository)resp.getData();
    }

    public ApiResponse<SourceRepository> updateSourceRepositoryWithHttpInfo(String resourceId, SourceRepository sourcerepository) throws ApiException {
        Call call = this.updateSourceRepositoryValidateBeforeCall(resourceId, sourcerepository, null, null);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateSourceRepositoryAsync(String resourceId, SourceRepository sourcerepository, ApiCallback<SourceRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateSourceRepositoryValidateBeforeCall(resourceId, sourcerepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateSourceRepositoryAttributesCall(String resourceId, SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SourceRepository localVarPostBody = sourcerepository;
        String localVarPath = "/sourcerepositories/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSourceRepositoryAttributesValidateBeforeCall(String resourceId, SourceRepository sourcerepository, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateSourceRepositoryAttributes(Async)");
        }
        if (sourcerepository == null) {
            throw new ApiException("Missing the required parameter 'sourcerepository' when calling updateSourceRepositoryAttributes(Async)");
        }
        Call call = this.updateSourceRepositoryAttributesCall(resourceId, sourcerepository, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepository updateSourceRepositoryAttributes(String resourceId, SourceRepository sourcerepository) throws ApiException {
        ApiResponse<SourceRepository> resp = this.updateSourceRepositoryAttributesWithHttpInfo(resourceId, sourcerepository);
        return (SourceRepository)resp.getData();
    }

    public ApiResponse<SourceRepository> updateSourceRepositoryAttributesWithHttpInfo(String resourceId, SourceRepository sourcerepository) throws ApiException {
        Call call = this.updateSourceRepositoryAttributesValidateBeforeCall(resourceId, sourcerepository, null, null);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateSourceRepositoryAttributesAsync(String resourceId, SourceRepository sourcerepository, ApiCallback<SourceRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateSourceRepositoryAttributesValidateBeforeCall(resourceId, sourcerepository, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

