/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.Library;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class LibrariesClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("LibrariesClient 1.0.0");

    public LibrariesClient() {
    }

    public LibrariesClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public LibrariesClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addLibraryCall(Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Library localVarPostBody = library;
        String localVarPath = "/libraries";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addLibraryValidateBeforeCall(Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (library == null) {
            throw new ApiException("Missing the required parameter 'library' when calling addLibrary(Async)");
        }
        Call call = this.addLibraryCall(library, progressListener, progressRequestListener);
        return call;
    }

    public Library addLibrary(Library library) throws ApiException {
        ApiResponse<Library> resp = this.addLibraryWithHttpInfo(library);
        return (Library)resp.getData();
    }

    public ApiResponse<Library> addLibraryWithHttpInfo(Library library) throws ApiException {
        Call call = this.addLibraryValidateBeforeCall(library, null, null);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addLibraryAsync(Library library, ApiCallback<Library> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addLibraryValidateBeforeCall(library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteLibraryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/libraries/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteLibraryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteLibrary(Async)");
        }
        Call call = this.deleteLibraryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteLibrary(String resourceId) throws ApiException {
        this.deleteLibraryWithHttpInfo(resourceId);
    }

    public ApiResponse<Void> deleteLibraryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteLibraryValidateBeforeCall(resourceId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteLibraryAsync(String resourceId, ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteLibraryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getLibrariesCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/libraries";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLibrariesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getLibrariesCall(progressListener, progressRequestListener);
        return call;
    }

    public List<Library> getLibraries() throws ApiException {
        ApiResponse<List<Library>> resp = this.getLibrariesWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<Library>> getLibrariesWithHttpInfo() throws ApiException {
        Call call = this.getLibrariesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<Library>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLibrariesAsync(ApiCallback<List<Library>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getLibrariesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Library>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLibraryCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/libraries/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLibraryValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getLibrary(Async)");
        }
        Call call = this.getLibraryCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public Library getLibrary(String resourceId) throws ApiException {
        ApiResponse<Library> resp = this.getLibraryWithHttpInfo(resourceId);
        return (Library)resp.getData();
    }

    public ApiResponse<Library> getLibraryWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getLibraryValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLibraryAsync(String resourceId, ApiCallback<Library> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getLibraryValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateLibraryCall(String resourceId, Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Library localVarPostBody = library;
        String localVarPath = "/libraries/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateLibraryValidateBeforeCall(String resourceId, Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateLibrary(Async)");
        }
        if (library == null) {
            throw new ApiException("Missing the required parameter 'library' when calling updateLibrary(Async)");
        }
        Call call = this.updateLibraryCall(resourceId, library, progressListener, progressRequestListener);
        return call;
    }

    public Library updateLibrary(String resourceId, Library library) throws ApiException {
        ApiResponse<Library> resp = this.updateLibraryWithHttpInfo(resourceId, library);
        return (Library)resp.getData();
    }

    public ApiResponse<Library> updateLibraryWithHttpInfo(String resourceId, Library library) throws ApiException {
        Call call = this.updateLibraryValidateBeforeCall(resourceId, library, null, null);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateLibraryAsync(String resourceId, Library library, ApiCallback<Library> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateLibraryValidateBeforeCall(resourceId, library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateLibraryAttributesCall(String resourceId, Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Library localVarPostBody = library;
        String localVarPath = "/libraries/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateLibraryAttributesValidateBeforeCall(String resourceId, Library library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateLibraryAttributes(Async)");
        }
        if (library == null) {
            throw new ApiException("Missing the required parameter 'library' when calling updateLibraryAttributes(Async)");
        }
        Call call = this.updateLibraryAttributesCall(resourceId, library, progressListener, progressRequestListener);
        return call;
    }

    public Library updateLibraryAttributes(String resourceId, Library library) throws ApiException {
        ApiResponse<Library> resp = this.updateLibraryAttributesWithHttpInfo(resourceId, library);
        return (Library)resp.getData();
    }

    public ApiResponse<Library> updateLibraryAttributesWithHttpInfo(String resourceId, Library library) throws ApiException {
        Call call = this.updateLibraryAttributesValidateBeforeCall(resourceId, library, null, null);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateLibraryAttributesAsync(String resourceId, Library library, ApiCallback<Library> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateLibraryAttributesValidateBeforeCall(resourceId, library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Library>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

