/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.ApiVersion;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class ApiVersionsClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("ApiVersionsClient 1.0.0");

    public ApiVersionsClient() {
    }

    public ApiVersionsClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public ApiVersionsClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addApiVersionCall(ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiVersion localVarPostBody = apiversion;
        String localVarPath = "/apiversions";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addApiVersionValidateBeforeCall(ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiversion == null) {
            throw new ApiException("Missing the required parameter 'apiversion' when calling addApiVersion(Async)");
        }
        Call call = this.addApiVersionCall(apiversion, progressListener, progressRequestListener);
        return call;
    }

    public ApiVersion addApiVersion(ApiVersion apiversion) throws ApiException {
        ApiResponse<ApiVersion> resp = this.addApiVersionWithHttpInfo(apiversion);
        return (ApiVersion)resp.getData();
    }

    public ApiResponse<ApiVersion> addApiVersionWithHttpInfo(ApiVersion apiversion) throws ApiException {
        Call call = this.addApiVersionValidateBeforeCall(apiversion, null, null);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addApiVersionAsync(ApiVersion apiversion, ApiCallback<ApiVersion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addApiVersionValidateBeforeCall(apiversion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteApiVersionCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apiversions/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteApiVersionValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling deleteApiVersion(Async)");
        }
        Call call = this.deleteApiVersionCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteApiVersion(String resourceId) throws ApiException {
        this.deleteApiVersionWithHttpInfo(resourceId);
    }

    public ApiResponse<Void> deleteApiVersionWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.deleteApiVersionValidateBeforeCall(resourceId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteApiVersionAsync(String resourceId, ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteApiVersionValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getApiVersionCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apiversions/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getApiVersionValidateBeforeCall(String resourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getApiVersion(Async)");
        }
        Call call = this.getApiVersionCall(resourceId, progressListener, progressRequestListener);
        return call;
    }

    public ApiVersion getApiVersion(String resourceId) throws ApiException {
        ApiResponse<ApiVersion> resp = this.getApiVersionWithHttpInfo(resourceId);
        return (ApiVersion)resp.getData();
    }

    public ApiResponse<ApiVersion> getApiVersionWithHttpInfo(String resourceId) throws ApiException {
        Call call = this.getApiVersionValidateBeforeCall(resourceId, null, null);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getApiVersionAsync(String resourceId, ApiCallback<ApiVersion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getApiVersionValidateBeforeCall(resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getApiVersionsCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apiversions";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getApiVersionsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getApiVersionsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<ApiVersion> getApiVersions() throws ApiException {
        ApiResponse<List<ApiVersion>> resp = this.getApiVersionsWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<ApiVersion>> getApiVersionsWithHttpInfo() throws ApiException {
        Call call = this.getApiVersionsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<ApiVersion>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getApiVersionsAsync(ApiCallback<List<ApiVersion>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getApiVersionsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ApiVersion>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateApiVersionCall(String resourceId, ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiVersion localVarPostBody = apiversion;
        String localVarPath = "/apiversions/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateApiVersionValidateBeforeCall(String resourceId, ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateApiVersion(Async)");
        }
        if (apiversion == null) {
            throw new ApiException("Missing the required parameter 'apiversion' when calling updateApiVersion(Async)");
        }
        Call call = this.updateApiVersionCall(resourceId, apiversion, progressListener, progressRequestListener);
        return call;
    }

    public ApiVersion updateApiVersion(String resourceId, ApiVersion apiversion) throws ApiException {
        ApiResponse<ApiVersion> resp = this.updateApiVersionWithHttpInfo(resourceId, apiversion);
        return (ApiVersion)resp.getData();
    }

    public ApiResponse<ApiVersion> updateApiVersionWithHttpInfo(String resourceId, ApiVersion apiversion) throws ApiException {
        Call call = this.updateApiVersionValidateBeforeCall(resourceId, apiversion, null, null);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateApiVersionAsync(String resourceId, ApiVersion apiversion, ApiCallback<ApiVersion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateApiVersionValidateBeforeCall(resourceId, apiversion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateApiVersionAttributesCall(String resourceId, ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiVersion localVarPostBody = apiversion;
        String localVarPath = "/apiversions/{resourceId}".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateApiVersionAttributesValidateBeforeCall(String resourceId, ApiVersion apiversion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateApiVersionAttributes(Async)");
        }
        if (apiversion == null) {
            throw new ApiException("Missing the required parameter 'apiversion' when calling updateApiVersionAttributes(Async)");
        }
        Call call = this.updateApiVersionAttributesCall(resourceId, apiversion, progressListener, progressRequestListener);
        return call;
    }

    public ApiVersion updateApiVersionAttributes(String resourceId, ApiVersion apiversion) throws ApiException {
        ApiResponse<ApiVersion> resp = this.updateApiVersionAttributesWithHttpInfo(resourceId, apiversion);
        return (ApiVersion)resp.getData();
    }

    public ApiResponse<ApiVersion> updateApiVersionAttributesWithHttpInfo(String resourceId, ApiVersion apiversion) throws ApiException {
        Call call = this.updateApiVersionAttributesValidateBeforeCall(resourceId, apiversion, null, null);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateApiVersionAttributesAsync(String resourceId, ApiVersion apiversion, ApiCallback<ApiVersion> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.updateApiVersionAttributesValidateBeforeCall(resourceId, apiversion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiVersion>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

