/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.reststop.cxfmetrics;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws22.EndpointImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.kantega.reststop.cxf.api.DefaultCxfPluginPlugin;

public class CxfMetricsPlugin
extends DefaultCxfPluginPlugin {
    private final MetricRegistry metricRegistry;

    public CxfMetricsPlugin(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void customizeEndpoint(Endpoint endpoint) {
        EndpointImpl e = (EndpointImpl)endpoint;
        e.getServer().getEndpoint().getInInterceptors().add(new TimingBeforeInterceptor("receive"));
        e.getServer().getEndpoint().getOutInterceptors().add(new TimingAfterInterceptor("send", this.metricRegistry));
    }

    private class TimingAfterInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private final MetricRegistry registry;

        private TimingAfterInterceptor(String phase, MetricRegistry registry) {
            super(phase);
            this.registry = registry;
        }

        public void handleMessage(Message message) throws Fault {
            Long time_before = (Long)message.getExchange().get((Object)"time_before");
            if (time_before != null) {
                QName operation = (QName)message.get((Object)"javax.xml.ws.wsdl.operation");
                String requestUri = (String)message.getExchange().getInMessage().get((Object)"org.apache.cxf.request.uri");
                String name = MetricRegistry.name((String)"WS", (String[])new String[]{operation.toString(), requestUri});
                this.registry.timer(name).update(System.nanoTime() - time_before, TimeUnit.NANOSECONDS);
            }
        }
    }

    private class TimingBeforeInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public TimingBeforeInterceptor(String phase) {
            super(phase);
        }

        public void handleMessage(Message message) throws Fault {
            message.getExchange().put((Object)"time_before", (Object)System.nanoTime());
        }
    }
}

