/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.respiro.jerseymetrics;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.ws.rs.Path;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.kantega.respiro.jerseymetrics.TimerAfterFilter;
import org.kantega.respiro.jerseymetrics.TimerBeforeFilter;

@Provider
public class TimerFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Path path;
        Method resourceMethod = resourceInfo.getResourceMethod();
        Class resourceClass = resourceInfo.getResourceClass();
        if (this.metricsDisabled(resourceClass)) {
            return;
        }
        Path methodPath = resourceMethod.getAnnotation(Path.class);
        Path classPath = resourceClass.getAnnotation(Path.class);
        Path path2 = path = methodPath != null ? methodPath : classPath;
        if (path != null) {
            UriBuilder builder = methodPath != null ? UriBuilder.fromResource((Class)resourceClass).path(resourceClass, resourceMethod.getName()) : UriBuilder.fromResource((Class)resourceClass);
            String template = builder.toTemplate();
            context.register((Object)new TimerBeforeFilter(template));
            context.register(TimerAfterFilter.class);
        }
    }

    private boolean metricsDisabled(Class<?> resourceClass) {
        try {
            Field metrics = resourceClass.getDeclaredField("METRICS");
            return Boolean.FALSE.equals(metrics.get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }
}

