/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.respiro.jerseymetrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.kantega.respiro.jerseymetrics.JerseyMetricsPlugin;

@Provider
public class TimerBeforeFilter
implements ContainerRequestFilter {
    private final String path;

    public TimerBeforeFilter(String path) {
        this.path = path;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MetricRegistry registry = JerseyMetricsPlugin.getMetricRegistry();
        String name = MetricRegistry.name((String)"REST", (String[])new String[]{requestContext.getMethod(), this.path});
        Timer.Context context = registry.timer(name).time();
        requestContext.setProperty("metrics.timeContext", (Object)context);
        requestContext.setProperty("metrics.path", (Object)this.path);
    }
}

