/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.metrics4jplugin.kairosdb;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.List;
import org.kairosdb.client.Client;
import org.kairosdb.client.HttpClient;
import org.kairosdb.client.TelnetClient;
import org.kairosdb.client.builder.Metric;
import org.kairosdb.client.builder.MetricBuilder;
import org.kairosdb.metrics4j.MetricsContext;
import org.kairosdb.metrics4j.formatters.DefaultFormatter;
import org.kairosdb.metrics4j.formatters.Formatter;
import org.kairosdb.metrics4j.internal.FormattedMetric;
import org.kairosdb.metrics4j.reporting.DoubleValue;
import org.kairosdb.metrics4j.reporting.LongValue;
import org.kairosdb.metrics4j.reporting.MetricValue;
import org.kairosdb.metrics4j.sinks.MetricSink;
import org.kairosdb.metrics4jplugin.kairosdb.TelnetClientAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KairosSink
implements MetricSink,
Closeable {
    private Logger logger = LoggerFactory.getLogger(KairosSink.class);
    private static final Formatter DEFAULT_FORMATTER = new DefaultFormatter();
    private Client m_client;
    private String hostUrl = "http://localhost";
    private String telnetHost = null;
    private int telnetPort = 4242;
    private Duration ttl = Duration.ofSeconds(0L);

    public void reportMetrics(List<FormattedMetric> metrics) {
        MetricBuilder builder = MetricBuilder.getInstance();
        for (FormattedMetric metric : metrics) {
            String metricTtl = (String)metric.getProps().get("ttl");
            long timeout = 0L;
            timeout = metricTtl != null ? Long.valueOf(metricTtl).longValue() : this.ttl.getSeconds();
            for (FormattedMetric.Sample sample : metric.getSamples()) {
                MetricValue value;
                Metric sendMetric = builder.addMetric(sample.getMetricName()).addTags(metric.getTags());
                if (timeout != 0L) {
                    sendMetric.addTtl((int)timeout);
                }
                if ((value = sample.getValue()) instanceof LongValue) {
                    sendMetric.addDataPoint(sample.getTime().toEpochMilli(), ((LongValue)value).getValue());
                    continue;
                }
                if (!(value instanceof DoubleValue)) continue;
                sendMetric.addDataPoint(sample.getTime().toEpochMilli(), ((DoubleValue)value).getValue());
            }
        }
        this.m_client.pushMetrics(builder);
    }

    public Formatter getDefaultFormatter() {
        return DEFAULT_FORMATTER;
    }

    public void init(MetricsContext context) {
        this.logger.info("Initializing Kairosdb client");
        if (this.telnetHost == null) {
            try {
                this.m_client = new HttpClient(this.hostUrl);
            }
            catch (MalformedURLException e) {
                this.logger.error("Malformed URL for Kairos client", (Throwable)e);
            }
        } else {
            try {
                this.m_client = new TelnetClientAdapter(new TelnetClient(this.telnetHost, this.telnetPort));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.m_client.close();
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    public void setTelnetHost(String telnetHost) {
        this.telnetHost = telnetHost;
    }

    public void setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
    }

    public void setTtl(Duration ttl) {
        this.ttl = ttl;
    }
}

