/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.kairosdb.client.response.ResponseHelper;

public class UnexpectedResponseException
extends RuntimeException {
    private final HttpUriRequest request;
    private final int statusCode;
    private final String statusMessage;
    private final ResponseHelper response;

    public UnexpectedResponseException(HttpUriRequest request, ResponseHelper response) {
        this(String.format("%d: %s", response.getStatusCode(), response.getStatusMessage()), request, response.getStatusCode(), response.getStatusMessage(), response);
    }

    public UnexpectedResponseException(String message, HttpUriRequest request, ResponseHelper response) {
        this(message, request, response.getStatusCode(), response.getStatusMessage(), response);
    }

    public UnexpectedResponseException(String message, HttpUriRequest request, int statusCode, String statusMessage, ResponseHelper response) {
        super(message);
        this.request = request;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.response = response;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String getHeader(String name) {
        List<String> values = this.getHeaders(name);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getHeaders(String name) {
        Header[] headers = this.response.getResponse().getHeaders(name);
        ArrayList<String> ret = new ArrayList<String>();
        if (headers != null) {
            for (Header header : headers) {
                ret.add(header.getValue());
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", (Object)this.response.getResponse().getAllHeaders()).toString();
    }
}

