/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.response.GroupResult;

public class Result {
    private String name;
    private Map<String, List<String>> tags;
    @SerializedName(value="values")
    private List<DataPoint> dataPoints;
    @SerializedName(value="group_by")
    private List<GroupResult> groupResults;

    public Result(String name, Map<String, List<String>> tags, List<DataPoint> dataPoints, List<GroupResult> groupResults) {
        this.name = name;
        this.tags = tags;
        this.groupResults = groupResults;
        this.dataPoints = dataPoints;
    }

    public String getName() {
        return this.name;
    }

    public List<DataPoint> getDataPoints() {
        return this.dataPoints != null ? this.dataPoints : Collections.EMPTY_LIST;
    }

    public Map<String, List<String>> getTags() {
        return this.tags != null ? this.tags : Collections.emptyMap();
    }

    public List<GroupResult> getGroupResults() {
        return this.groupResults != null ? this.groupResults : Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (!this.name.equals(result.name)) {
            return false;
        }
        if (!this.tags.equals(result.tags)) {
            return false;
        }
        if (!this.dataPoints.equals(result.dataPoints)) {
            return false;
        }
        return this.groupResults.equals(result.groupResults);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tags.hashCode();
        result = 31 * result + this.dataPoints.hashCode();
        result = 31 * result + this.groupResults.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("tags", this.tags).add("dataPoints", this.dataPoints).add("groupResults", this.groupResults).toString();
    }
}

