/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.Result;

public class QueryResult {
    private List<Result> results;
    @SerializedName(value="sample_size")
    private long sampleSize;

    public QueryResult(List<Result> results, long sampleSize) {
        this.results = results;
        this.sampleSize = sampleSize;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public Result getFirstResultByGroup(GroupResult matchingGroup) {
        for (Result result : this.results) {
            if (result == null) continue;
            for (GroupResult groupResult : result.getGroupResults()) {
                if (!matchingGroup.equals(groupResult)) continue;
                return result;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (this.sampleSize != that.sampleSize) {
            return false;
        }
        return this.results != null ? this.results.equals(that.results) : that.results == null;
    }

    public int hashCode() {
        int result = this.results != null ? this.results.hashCode() : 0;
        result = 31 * result + (int)(this.sampleSize ^ this.sampleSize >>> 32);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("results", this.results).add("sampleSize", this.sampleSize).toString();
    }
}

