/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.grouper;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.util.Preconditions;

public class TagGrouper
extends Grouper {
    @SerializedName(value="tags")
    private List<String> tagNames = new ArrayList<String>();

    public TagGrouper(String ... tagNames) {
        super("tag");
        Preconditions.checkArgument(tagNames.length > 0);
        for (String tagName : tagNames) {
            this.tagNames.add(Preconditions.checkNotNullOrEmpty(tagName));
        }
    }

    public TagGrouper(List<String> tagNames) {
        super("tag");
        Objects.requireNonNull(tagNames);
        this.tagNames = tagNames;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagGrouper that = (TagGrouper)o;
        return !(this.tagNames == null ? that.tagNames != null : !this.tagNames.equals(that.tagNames));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tagNames != null ? this.tagNames.hashCode() : 0);
        return result;
    }
}

