/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.aggregator;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.util.Preconditions;

public class SamplingAggregator
extends Aggregator {
    private Sampling sampling;
    @SerializedName(value="align_start_time")
    private Boolean alignStartTime;
    @SerializedName(value="align_end_time")
    private Boolean alignEndTime;
    @SerializedName(value="align_sampling")
    private Boolean alignSampling;
    @SerializedName(value="start_time")
    private Long startTime;

    public SamplingAggregator(String name, long value, TimeUnit unit) {
        super(name);
        Preconditions.checkArgument(value > 0L, "value must be greater than 0.");
        this.sampling = new Sampling(value, unit);
    }

    public long getValue() {
        return this.sampling.value;
    }

    public TimeUnit getUnit() {
        return this.sampling.unit;
    }

    public SamplingAggregator withSamplingAlignment() {
        this.alignSampling = true;
        return this;
    }

    public SamplingAggregator withStartTimeAlignment() {
        this.alignStartTime = true;
        return this;
    }

    public SamplingAggregator withEndTimeAlignment() {
        this.alignEndTime = true;
        return this;
    }

    public SamplingAggregator withStartTimeAlignment(long startTime) {
        Preconditions.checkArgument(startTime >= 0L, "startTime cannot be negative");
        this.alignStartTime = true;
        this.startTime = startTime;
        return this;
    }

    public SamplingAggregator withEndTimeAlignment(long startTime) {
        Preconditions.checkArgument(startTime >= 0L, "startTime cannot be negative");
        this.alignEndTime = true;
        this.startTime = startTime;
        return this;
    }

    @Deprecated
    public SamplingAggregator withAlignment(Boolean alignStartTime, Boolean alignSampling) {
        this.alignStartTime = alignStartTime;
        this.alignSampling = alignSampling;
        return this;
    }

    public Boolean isAlignStartTime() {
        return this.alignStartTime != null ? this.alignStartTime : false;
    }

    public Boolean isAlignEndTime() {
        return this.alignEndTime != null ? this.alignEndTime : false;
    }

    public Boolean isAlignSampling() {
        return this.alignSampling != null ? this.alignSampling : false;
    }

    public long getStartTimeAlignmentStartTime() {
        return this.startTime != null ? this.startTime : 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SamplingAggregator that = (SamplingAggregator)o;
        if (this.sampling != null ? !this.sampling.equals(that.sampling) : that.sampling != null) {
            return false;
        }
        if (this.alignStartTime != null ? !this.alignStartTime.equals(that.alignStartTime) : that.alignStartTime != null) {
            return false;
        }
        if (this.alignEndTime != null ? !this.alignEndTime.equals(that.alignEndTime) : that.alignEndTime != null) {
            return false;
        }
        if (this.alignSampling != null ? !this.alignSampling.equals(that.alignSampling) : that.alignSampling != null) {
            return false;
        }
        return !(this.startTime == null ? that.startTime != null : !this.startTime.equals(that.startTime));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sampling != null ? this.sampling.hashCode() : 0);
        result = 31 * result + (this.alignStartTime != null ? this.alignStartTime.hashCode() : 0);
        result = 31 * result + (this.alignEndTime != null ? this.alignEndTime.hashCode() : 0);
        result = 31 * result + (this.alignSampling != null ? this.alignSampling.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        return result;
    }

    private class Sampling {
        private long value;
        private TimeUnit unit;

        private Sampling(long value, TimeUnit unit) {
            this.value = value;
            this.unit = Objects.requireNonNull(unit);
        }
    }
}

