/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.builder.Rollup;
import org.kairosdb.client.util.Preconditions;

public class RollupTask {
    private final String id;
    private final List<Rollup> rollups = new ArrayList<Rollup>();
    private final String name;
    @SerializedName(value="execution_interval")
    private final RelativeTime executionInterval;
    private final long lastModified;

    public RollupTask(String id, String name, RelativeTime executionInterval, long lastModified) {
        this.id = Preconditions.checkNotNullOrEmpty(id, "id cannot be null or empty", new Object[0]);
        this.name = Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
        this.executionInterval = Objects.requireNonNull(executionInterval, "executionInterval cannot be null");
        this.lastModified = lastModified;
    }

    public String getId() {
        return this.id;
    }

    public List<Rollup> getRollups() {
        return this.rollups;
    }

    public String getName() {
        return this.name;
    }

    public RelativeTime getExecutionInterval() {
        return this.executionInterval;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupTask that = (RollupTask)o;
        if (this.lastModified != that.lastModified) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (!this.rollups.equals(that.rollups)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.executionInterval.equals(that.executionInterval);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.rollups.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.executionInterval.hashCode();
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        return result;
    }

    public String toString() {
        return "RollupTask{id='" + this.id + "', rollups=" + this.rollups + ", name='" + this.name + "', executionInterval=" + this.executionInterval + ", lastModified=" + this.lastModified + "}";
    }
}

