/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.kairosdb.client.builder.QueryMetric;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.builder.Rollup;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.builder.grouper.CustomGrouper;
import org.kairosdb.client.serializer.CustomAggregatorSerializer;
import org.kairosdb.client.serializer.CustomGrouperSerializer;
import org.kairosdb.client.serializer.ListMultiMapSerializer;
import org.kairosdb.client.serializer.OrderSerializer;
import org.kairosdb.client.serializer.TimeZoneSerializer;
import org.kairosdb.client.util.Preconditions;

public class RollupBuilder {
    private final transient Gson mapper;
    private final String name;
    @SerializedName(value="execution_interval")
    private final RelativeTime executionInterval;
    private final List<Rollup> rollups = new ArrayList<Rollup>();

    private RollupBuilder(String name, RelativeTime executionInterval) {
        this.name = Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
        this.executionInterval = Objects.requireNonNull(executionInterval, "executionInterval cannot be null");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CustomAggregator.class, (Object)new CustomAggregatorSerializer());
        builder.registerTypeAdapter(CustomGrouper.class, (Object)new CustomGrouperSerializer());
        builder.registerTypeAdapter(ListMultimap.class, (Object)new ListMultiMapSerializer());
        builder.registerTypeAdapter(QueryMetric.Order.class, (Object)new OrderSerializer());
        builder.registerTypeAdapter(TimeZone.class, (Object)new TimeZoneSerializer());
        this.mapper = builder.create();
    }

    public static RollupBuilder getInstance(String name, RelativeTime executionInterval) {
        Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
        Objects.requireNonNull(executionInterval, "executionInterval cannot be null");
        return new RollupBuilder(name, executionInterval);
    }

    public Rollup addRollup(String saveAs) {
        Rollup rollup = new Rollup(saveAs);
        this.rollups.add(rollup);
        return rollup;
    }

    public String build() {
        this.validate();
        return this.mapper.toJson((Object)this);
    }

    private void validate() {
        Preconditions.checkState(this.rollups.size() > 0, "No roll-ups added");
        for (Rollup rollup : this.rollups) {
            rollup.validate();
        }
    }
}

