/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.kairosdb.client.builder.QueryBuilder;
import org.kairosdb.client.builder.QueryMetric;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.util.Preconditions;

public class Rollup {
    @SerializedName(value="save_as")
    private final String saveAs;
    @SerializedName(value="query")
    private QueryBuilder builder;

    Rollup(String saveAs) {
        this.saveAs = Preconditions.checkNotNullOrEmpty(saveAs, "saveAs cannot be null or empty", new Object[0]);
    }

    public QueryBuilder addQuery() {
        this.builder = QueryBuilder.getInstance();
        return this.builder;
    }

    public Date getStartAbsolute() {
        return this.builder.getStartAbsolute();
    }

    public Date getEndAbsolute() {
        return this.builder.getEndAbsolute();
    }

    public RelativeTime getStartRelative() {
        return this.builder.getStartRelative();
    }

    public int getCacheTime() {
        return this.builder.getCacheTime();
    }

    public TimeZone getTimeZone() {
        return this.builder.getTimeZone();
    }

    public List<QueryMetric> getMetrics() {
        return this.builder.getMetrics();
    }

    public String getSaveAs() {
        return this.saveAs;
    }

    void validate() {
        Objects.requireNonNull(this.builder, "No queries added to rollup " + this.saveAs);
        this.builder.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollup rollup = (Rollup)o;
        if (!this.saveAs.equals(rollup.saveAs)) {
            return false;
        }
        return this.builder.equals(rollup.builder);
    }

    public int hashCode() {
        int result = this.saveAs.hashCode();
        result = 31 * result + this.builder.hashCode();
        return result;
    }

    public String toString() {
        return "Rollup{saveAs='" + this.saveAs + "', builder=" + this.builder + "}";
    }
}

