/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kairosdb.client.util.Preconditions;

public class QueryTagMetric {
    private final String name;
    private final ListMultimap<String, String> tags = ArrayListMultimap.create();

    public QueryTagMetric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
    }

    public QueryTagMetric addTags(Map<String, String> tags) {
        Objects.requireNonNull(tags);
        for (String key : tags.keySet()) {
            this.tags.put((Object)key, (Object)tags.get(key));
        }
        return this;
    }

    public QueryTagMetric addTag(String name, String ... values) {
        Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "value must be greater than 0");
        for (String value : values) {
            Preconditions.checkNotNullOrEmpty(value, "value cannot be null or empty", new Object[0]);
        }
        this.tags.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    public QueryTagMetric addTag(String name, Set<String> values) {
        Preconditions.checkNotNullOrEmpty(name, "name cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(values.size() > 0, "value must be greater than 0");
        for (String value : values) {
            Preconditions.checkNotNullOrEmpty(value, "value cannot be null or empty", new Object[0]);
        }
        this.tags.putAll((Object)name, values);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ListMultimap<String, String> getTags() {
        return this.tags;
    }
}

