/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.util.Preconditions;

public class QueryMetric {
    private final String name;
    private final ListMultimap<String, String> tags = ArrayListMultimap.create();
    @SerializedName(value="group_by")
    private final List<Grouper> groupers = new ArrayList<Grouper>();
    private final List<Aggregator> aggregators = new ArrayList<Aggregator>();
    private Integer limit;
    private Order order;
    @SerializedName(value="exclude_tags")
    private boolean excludeTags;

    public QueryMetric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    public QueryMetric addMultiValuedTags(Map<String, List<String>> tags) {
        Objects.requireNonNull(tags);
        for (String key : tags.keySet()) {
            this.tags.putAll((Object)key, (Iterable)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTags(Map<String, String> tags) {
        Objects.requireNonNull(tags);
        for (String key : tags.keySet()) {
            this.tags.put((Object)key, (Object)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTag(String name, String ... values) {
        Preconditions.checkNotNullOrEmpty(name);
        Preconditions.checkArgument(values.length > 0);
        for (String value : values) {
            Preconditions.checkNotNullOrEmpty(value);
        }
        this.tags.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    public QueryMetric addAggregator(Aggregator aggregator) {
        Objects.requireNonNull(aggregator);
        this.aggregators.add(aggregator);
        return this;
    }

    public QueryMetric addGrouper(Grouper grouper) {
        Objects.requireNonNull(grouper);
        this.groupers.add(grouper);
        return this;
    }

    public void setLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "limit must be greater than 0");
        this.limit = limit;
    }

    public void setOrder(Order order) {
        Objects.requireNonNull(order);
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public ListMultimap<String, String> getTags() {
        return this.tags;
    }

    public List<Grouper> getGroupers() {
        return this.groupers;
    }

    public List<Aggregator> getAggregators() {
        return this.aggregators;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isExcludeTags() {
        return this.excludeTags;
    }

    public void setExcludeTags(boolean exclude) {
        this.excludeTags = exclude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryMetric that = (QueryMetric)o;
        if (this.excludeTags != that.excludeTags) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.groupers != null ? !this.groupers.equals(that.groupers) : that.groupers != null) {
            return false;
        }
        if (this.aggregators != null ? !this.aggregators.equals(that.aggregators) : that.aggregators != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return this.order == that.order;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.groupers != null ? this.groupers.hashCode() : 0);
        result = 31 * result + (this.aggregators != null ? this.aggregators.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
        result = 31 * result + (this.excludeTags ? 1 : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("tags", this.tags).append("groupers", this.groupers).append("aggregators", this.aggregators).append("limit", (Object)this.limit).append("order", (Object)this.order).append("excludeTags", this.excludeTags).toString();
    }

    public static enum Order {
        ASCENDING("asc"),
        DESCENDING("desc");

        private String text;

        private Order(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

