/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.kairosdb.client.builder.AbstractQueryBuilder;
import org.kairosdb.client.builder.QueryMetric;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.builder.grouper.CustomGrouper;
import org.kairosdb.client.serializer.CustomAggregatorSerializer;
import org.kairosdb.client.serializer.CustomGrouperSerializer;
import org.kairosdb.client.serializer.ListMultiMapSerializer;
import org.kairosdb.client.serializer.OrderSerializer;
import org.kairosdb.client.serializer.TimeZoneSerializer;
import org.kairosdb.client.util.Preconditions;

public class QueryBuilder
extends AbstractQueryBuilder<QueryBuilder> {
    @SerializedName(value="cache_time")
    private int cacheTime;
    @SerializedName(value="time_zone")
    private TimeZone timeZone;
    private List<QueryMetric> metrics = new ArrayList<QueryMetric>();

    private QueryBuilder() {
    }

    @Override
    protected Gson buildGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CustomAggregator.class, (Object)new CustomAggregatorSerializer());
        builder.registerTypeAdapter(CustomGrouper.class, (Object)new CustomGrouperSerializer());
        builder.registerTypeAdapter(ListMultimap.class, (Object)new ListMultiMapSerializer());
        builder.registerTypeAdapter(QueryMetric.Order.class, (Object)new OrderSerializer());
        builder.registerTypeAdapter(TimeZone.class, (Object)new TimeZoneSerializer());
        return builder.create();
    }

    public QueryBuilder setCacheTime(int cacheTime) {
        Preconditions.checkArgument(cacheTime > 0, "Cache time must be greater than 0.");
        this.cacheTime = cacheTime;
        return this;
    }

    public QueryMetric addMetric(QueryMetric metric) {
        Objects.requireNonNull(metric, "metric cannot be null");
        this.metrics.add(metric);
        return metric;
    }

    public static QueryBuilder getInstance() {
        return new QueryBuilder();
    }

    public QueryMetric addMetric(String name) {
        Preconditions.checkNotNullOrEmpty(name, "Name cannot be null or empty.", new Object[0]);
        QueryMetric metric = new QueryMetric(name);
        this.metrics.add(metric);
        return metric;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public List<QueryMetric> getMetrics() {
        return this.metrics;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getTimeZone("UTC");
        }
        return this.timeZone;
    }

    public QueryBuilder setTimeZone(TimeZone timeZone) {
        Objects.requireNonNull(timeZone, "timezone cannot be null");
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryBuilder that = (QueryBuilder)o;
        if (this.cacheTime != that.cacheTime) {
            return false;
        }
        if (this.timeZone == null ? that.timeZone != null : !this.timeZone.equals(that.timeZone)) {
            return false;
        }
        return this.metrics.equals(that.metrics);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cacheTime;
        result = 31 * result + this.timeZone.hashCode();
        result = 31 * result + this.metrics.hashCode();
        return result;
    }

    public String toString() {
        return "QueryBuilder{cacheTime=" + this.cacheTime + ", timeZone=" + this.timeZone + ", metrics=" + this.metrics + ", startAbsolute=" + this.startAbsolute + ", endAbsolute=" + this.endAbsolute + ", startRelative=" + this.startRelative + ", endRelative=" + this.endRelative + "}";
    }
}

