/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.util.Preconditions;

public class Metric {
    private String name;
    private Map<String, String> tags = new HashMap<String, String>();
    private String type;
    private int ttl;
    @SerializedName(value="datapoints")
    private List<DataPoint> dataPoints = new ArrayList<DataPoint>();

    protected Metric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    protected Metric(String name, String registeredType) {
        this(name);
        this.type = registeredType;
    }

    public Metric addTag(String name, String value) {
        Preconditions.checkNotNullOrEmpty(name);
        Preconditions.checkNotNullOrEmpty(value);
        this.tags.put(name, value);
        return this;
    }

    public Metric addTags(Map<String, String> tags) {
        Objects.requireNonNull(tags);
        this.tags.putAll(tags);
        return this;
    }

    public Metric addDataPoint(long timestamp, long value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(long value) {
        return this.addDataPoint(System.currentTimeMillis(), value);
    }

    public Metric addDataPoint(long timestamp, Object value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(long timestamp, double value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(double value) {
        return this.addDataPoint(System.currentTimeMillis(), value);
    }

    public Metric addTtl(int ttl) {
        Preconditions.checkArgument(ttl >= 0, "tll must be greater than or equal to zero");
        this.ttl = ttl;
        return this;
    }

    public int getTtl() {
        return this.ttl;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.dataPoints);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        if (this.name != null ? !this.name.equals(metric.name) : metric.name != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(metric.tags) : metric.tags != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(metric.type) : metric.type != null) {
            return false;
        }
        return !(this.dataPoints == null ? metric.dataPoints != null : !this.dataPoints.equals(metric.dataPoints));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dataPoints != null ? this.dataPoints.hashCode() : 0);
        return result;
    }
}

