/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.kairosdb.client.Client;
import org.kairosdb.client.DataPointTypeRegistry;
import org.kairosdb.client.builder.MetricBuilder;
import org.kairosdb.client.builder.QueryBuilder;
import org.kairosdb.client.builder.QueryTagBuilder;
import org.kairosdb.client.builder.RollupBuilder;
import org.kairosdb.client.builder.RollupTask;
import org.kairosdb.client.response.DefaultJsonResponseHandler;
import org.kairosdb.client.response.JsonResponseHandler;
import org.kairosdb.client.response.QueryResponse;
import org.kairosdb.client.response.QueryTagResponse;
import org.kairosdb.client.response.ResponseHelper;
import org.kairosdb.client.util.Exceptions;
import org.kairosdb.client.util.Preconditions;

public class HttpClient
implements Client {
    private static final String GZIP = "gzip";
    private static final String PATH_ROLLUPS = "/api/v1/rollups/";
    private static final String PATH_METRIC_NAMES = "/api/v1/metricnames";
    private static final String PATH_STATUS = "/api/v1/health/status";
    private static final String PATH_CHECK = "/api/v1/health/check";
    private static final String PATH_VERSION = "/api/v1/version";
    private static final String PATH_QUERY = "/api/v1/datapoints/query";
    private static final String PATH_QUERY_TAGS = "/api/v1/datapoints/query/tags";
    private static final String PATH_DELETE = "/api/v1/datapoints/delete";
    private static final String PATH_DATAPOINTS = "/api/v1/datapoints";
    private static final String PATH_METRIC = "/api/v1/metric/";
    private final CloseableHttpClient client;
    private final String url;
    private final DataPointTypeRegistry typeRegistry;

    public HttpClient(String url) throws MalformedURLException {
        this(HttpClientBuilder.create().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler()), url);
    }

    public HttpClient(HttpClientBuilder builder, String url) throws MalformedURLException {
        Preconditions.checkNotNullOrEmpty(url, "url cannot be null", new Object[0]);
        Objects.requireNonNull(builder, "builder must not be null");
        this.url = url;
        new URL(url);
        this.client = builder.build();
        this.typeRegistry = new DataPointTypeRegistry();
    }

    public HttpClient(CloseableHttpClient client, String url) throws MalformedURLException {
        Preconditions.checkNotNullOrEmpty(url, "url cannot be null", new Object[0]);
        Objects.requireNonNull(client, "client must not be null");
        this.url = url;
        new URL(url);
        this.client = client;
        this.typeRegistry = new DataPointTypeRegistry();
    }

    @Override
    public void registerCustomDataType(String groupType, Class dataPointClass) {
        Preconditions.checkNotNullOrEmpty(groupType, "groupType may not be null or empty", new Object[0]);
        Objects.requireNonNull(dataPointClass, "dataPointClass may not be null");
        this.typeRegistry.registerCustomDataType(groupType, dataPointClass);
    }

    @Override
    public Class getDataPointValueClass(String groupType) {
        return this.typeRegistry.getDataPointValueClass(groupType);
    }

    public DataPointTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public RollupTask createRollupTask(RollupBuilder builder) {
        DefaultJsonResponseHandler<RollupTaskResponse> responseHandler = new DefaultJsonResponseHandler<RollupTaskResponse>(RollupTaskResponse.class, this.typeRegistry);
        RollupTaskResponse rollupTaskResponse = this.postData(PATH_ROLLUPS, builder.build(), responseHandler);
        Preconditions.checkNotNullOrEmpty(rollupTaskResponse.id, "No task id was returned in the rollup-task", new Object[0]);
        return this.getRollupTask(rollupTaskResponse.id);
    }

    @Override
    public List<RollupTask> getRollupTasks() {
        Type type = new TypeToken<List<RollupTask>>(){}.getType();
        return (List)this.queryData(PATH_ROLLUPS, new DefaultJsonResponseHandler(type, this.typeRegistry));
    }

    @Override
    public RollupTask getRollupTask(String id) {
        return this.queryData(PATH_ROLLUPS + id, new DefaultJsonResponseHandler<RollupTask>(RollupTask.class, this.typeRegistry));
    }

    @Override
    public void deleteRollupTask(String id) {
        this.delete(PATH_ROLLUPS + id, new DefaultJsonResponseHandler<Void>(Void.class, this.typeRegistry));
    }

    @Override
    public List<String> getMetricNames() {
        Results results = this.queryData(PATH_METRIC_NAMES, new DefaultJsonResponseHandler<Results>(Results.class, this.typeRegistry));
        return results.results;
    }

    @Override
    public List<String> getStatus() {
        Type type = new TypeToken<List<String>>(){}.getType();
        return (List)this.queryData(PATH_STATUS, new DefaultJsonResponseHandler(type, this.typeRegistry));
    }

    @Override
    public int getStatusCheck() {
        return this.queryData(PATH_CHECK, new JsonResponseHandler<Integer>(){

            @Override
            public Integer handleException(HttpUriRequest request, Exception exception) throws RuntimeException {
                throw Exceptions.propagate(request, exception);
            }

            @Override
            public Integer handle(HttpUriRequest request, ResponseHelper response) throws RuntimeException {
                return response.getStatusCode();
            }
        });
    }

    @Override
    public String getVersion() {
        Version version = this.queryData(PATH_VERSION, new DefaultJsonResponseHandler<Version>(Version.class, this.typeRegistry));
        return version.version;
    }

    @Override
    public <T> T query(QueryBuilder builder, JsonResponseHandler<T> handler) {
        return this.postData(PATH_QUERY, builder.build(), handler);
    }

    @Override
    public QueryResponse query(QueryBuilder builder) {
        DefaultJsonResponseHandler<QueryResponse> responseHandler = new DefaultJsonResponseHandler<QueryResponse>(QueryResponse.class, this.typeRegistry);
        return this.postData(PATH_QUERY, builder.build(), responseHandler);
    }

    @Override
    public QueryTagResponse queryTags(QueryTagBuilder builder) {
        DefaultJsonResponseHandler<QueryTagResponse> responseHandler = new DefaultJsonResponseHandler<QueryTagResponse>(QueryTagResponse.class, this.typeRegistry);
        return this.postData(PATH_QUERY_TAGS, builder.build(), responseHandler);
    }

    @Override
    public <T> T queryTags(QueryTagBuilder builder, JsonResponseHandler<T> handler) {
        return this.postData(PATH_QUERY_TAGS, builder.build(), handler);
    }

    @Override
    public void pushMetrics(MetricBuilder builder) {
        this.postData(PATH_DATAPOINTS, builder.build(), new DefaultJsonResponseHandler<Void>(Void.class, this.typeRegistry), builder.isCompressionEnabled());
    }

    @Override
    public void deleteMetric(String name) {
        this.delete(PATH_METRIC + name, new DefaultJsonResponseHandler<Void>(Void.class, this.typeRegistry));
    }

    @Override
    public void delete(QueryBuilder builder) {
        this.postData(PATH_DELETE, builder.build(), new DefaultJsonResponseHandler<Void>(Void.class, this.typeRegistry));
    }

    private <T> T postData(String path, String json, JsonResponseHandler<T> responseHandler) {
        return this.postData(path, json, responseHandler, false);
    }

    private <T> T postData(String path, String json, JsonResponseHandler<T> responseHandler, boolean compressed) {
        HttpPost post = new HttpPost(this.createURI(path));
        EntityBuilder entityBuilder = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(json);
        if (compressed) {
            entityBuilder.gzipCompress();
            post.addHeader("Content-Encoding", GZIP);
        } else {
            post.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        post.setEntity(entityBuilder.build());
        return this.execute((HttpUriRequest)post, responseHandler);
    }

    private <T> T queryData(String path, JsonResponseHandler<T> responseHandler) {
        HttpGet get = new HttpGet(this.createURI(path));
        get.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        get.addHeader("Accept-Encoding", GZIP);
        return this.execute((HttpUriRequest)get, responseHandler);
    }

    private <T> T delete(String path, JsonResponseHandler<T> responseHandler) {
        HttpDelete delete = new HttpDelete(this.createURI(path));
        delete.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        return this.execute((HttpUriRequest)delete, responseHandler);
    }

    private URI createURI(String path) {
        try {
            return new URI(this.url + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
    }

    private <T> T execute(HttpUriRequest request, JsonResponseHandler<T> responseHandler) {
        try {
            CloseableHttpResponse response = this.client.execute(request);
            return responseHandler.handle(request, new ResponseHelper((HttpResponse)response));
        }
        catch (IOException e) {
            return responseHandler.handleException(request, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private class Version {
        private String version;

        private Version() {
        }
    }

    private class Attributes {
        private String url;

        private Attributes() {
        }
    }

    class RollupTaskResponse {
        private String id;
        private String name;
        private Attributes attributes;

        RollupTaskResponse() {
        }

        String getId() {
            return this.id;
        }
    }

    private class Results {
        private List<String> results;

        private Results() {
        }
    }
}

