/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import java.util.HashMap;
import java.util.Map;
import org.kairosdb.client.util.Preconditions;

public class DataPointTypeRegistry {
    private Map<String, Class> customGroupTypes = new HashMap<String, Class>();

    public DataPointTypeRegistry() {
        this.customGroupTypes.put("number", Number.class);
        this.customGroupTypes.put("text", String.class);
    }

    public void registerCustomDataType(String groupType, Class dataPointClass) {
        Preconditions.checkArgument(!this.customGroupTypes.containsKey(groupType), "Type has already been registered");
        this.customGroupTypes.put(groupType, dataPointClass);
    }

    public Class getDataPointValueClass(String groupType) {
        Class valueClass = this.customGroupTypes.get(groupType);
        return valueClass == null ? Number.class : valueClass;
    }
}

