/*
 * Decompiled with CFR 0.152.
 */
package org.kariosdb.bigqueue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kairosdb.metrics4j.MetricSourceManager;
import org.kariosdb.bigqueue.BigArrayImpl;
import org.kariosdb.bigqueue.IBigArray;
import org.kariosdb.bigqueue.IBigQueue;
import org.kariosdb.bigqueue.metrics.BigQueueStats;
import org.kariosdb.bigqueue.page.IMappedPage;
import org.kariosdb.bigqueue.page.IMappedPageFactory;
import org.kariosdb.bigqueue.page.MappedPageFactoryImpl;

public class BigQueueImpl
implements IBigQueue {
    private static final BigQueueStats stats = (BigQueueStats)MetricSourceManager.getSource(BigQueueStats.class);
    final IBigArray innerArray;
    static final int QUEUE_FRONT_INDEX_ITEM_LENGTH_BITS = 3;
    static final int QUEUE_FRONT_INDEX_PAGE_SIZE = 8;
    static final long QUEUE_FRONT_PAGE_INDEX = 0L;
    static final String QUEUE_FRONT_INDEX_PAGE_FOLDER = "front_index";
    final AtomicLong queueFrontIndex = new AtomicLong();
    private final String queueName;
    IMappedPageFactory queueFrontIndexPageFactory;
    final Lock queueFrontWriteLock = new ReentrantLock();
    private final Object futureLock = new Object();
    private CompletableFuture<byte[]> dequeueFuture;
    private CompletableFuture<byte[]> peekFuture;

    public BigQueueImpl(String queueDir, String queueName) throws IOException {
        this(queueDir, queueName, 0x8000000);
    }

    public BigQueueImpl(String queueDir, String queueName, int pageSize) throws IOException {
        this.innerArray = new BigArrayImpl(queueDir, queueName, pageSize);
        this.queueName = queueName;
        this.queueFrontIndexPageFactory = new MappedPageFactoryImpl(8, ((BigArrayImpl)this.innerArray).getArrayDirectory() + QUEUE_FRONT_INDEX_PAGE_FOLDER, 10000L);
        IMappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
        ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
        long front = queueFrontIndexBuffer.getLong();
        this.queueFrontIndex.set(front);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("name", queueName);
        MetricSourceManager.addSource((String)BigQueueStats.class.getName(), (String)"queueSize", tags, (String)"Reports size of the queue", () -> this.size());
    }

    @Override
    public boolean isEmpty() {
        return this.queueFrontIndex.get() == this.innerArray.getHeadIndex();
    }

    @Override
    public void enqueue(byte[] data) throws IOException {
        this.innerArray.append(data);
        this.completeFutures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dequeue() throws IOException {
        long queueFrontIndex = -1L;
        try {
            this.queueFrontWriteLock.lock();
            if (this.isEmpty()) {
                byte[] byArray = null;
                return byArray;
            }
            queueFrontIndex = this.queueFrontIndex.get();
            byte[] data = this.innerArray.get(queueFrontIndex);
            long nextQueueFrontIndex = queueFrontIndex;
            nextQueueFrontIndex = nextQueueFrontIndex == Long.MAX_VALUE ? 0L : ++nextQueueFrontIndex;
            this.queueFrontIndex.set(nextQueueFrontIndex);
            IMappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
            ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
            queueFrontIndexBuffer.putLong(nextQueueFrontIndex);
            queueFrontIndexPage.setDirty(true);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    @Override
    public CompletableFuture<byte[]> dequeueAsync() {
        this.initializeDequeueFutureIfNecessary();
        return this.dequeueFuture;
    }

    @Override
    public void removeAll() throws IOException {
        try {
            this.queueFrontWriteLock.lock();
            this.innerArray.removeAll();
            this.queueFrontIndex.set(0L);
            IMappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
            ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
            queueFrontIndexBuffer.putLong(0L);
            queueFrontIndexPage.setDirty(true);
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    @Override
    public byte[] peek() throws IOException {
        if (this.isEmpty()) {
            return null;
        }
        byte[] data = this.innerArray.get(this.queueFrontIndex.get());
        return data;
    }

    @Override
    public CompletableFuture<byte[]> peekAsync() {
        this.initializePeekFutureIfNecessary();
        return this.peekFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForEach(IBigQueue.ItemIterator iterator) throws IOException {
        try {
            long index;
            this.queueFrontWriteLock.lock();
            if (this.isEmpty()) {
                return;
            }
            for (long i = index = this.queueFrontIndex.get(); i < this.innerArray.size(); ++i) {
                iterator.forEach(this.innerArray.get(i));
            }
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.queueFrontIndexPageFactory != null) {
            this.queueFrontIndexPageFactory.releaseCachedPages();
        }
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture != null) {
                this.peekFuture.cancel(false);
            }
            if (this.dequeueFuture != null) {
                this.dequeueFuture.cancel(false);
            }
        }
        this.innerArray.close();
    }

    @Override
    public void gc() throws IOException {
        stats.gcCount(this.queueName).put(1L);
        long beforeIndex = this.queueFrontIndex.get();
        beforeIndex = beforeIndex == 0L ? Long.MAX_VALUE : --beforeIndex;
        try {
            this.innerArray.removeBeforeIndex(beforeIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this.queueFrontWriteLock.lock();
            this.queueFrontIndexPageFactory.flush();
            this.innerArray.flush();
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    @Override
    public long size() {
        long qRear;
        long qFront = this.queueFrontIndex.get();
        if (qFront <= (qRear = this.innerArray.getHeadIndex())) {
            return qRear - qFront;
        }
        return Long.MAX_VALUE - qFront + 1L + qRear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeFutures() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture != null && !this.peekFuture.isDone()) {
                try {
                    this.peekFuture.complete(this.peek());
                }
                catch (IOException e) {
                    this.peekFuture.completeExceptionally(e);
                }
            }
            if (this.dequeueFuture != null && !this.dequeueFuture.isDone()) {
                try {
                    this.dequeueFuture.complete(this.dequeue());
                }
                catch (IOException e) {
                    this.dequeueFuture.completeExceptionally(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDequeueFutureIfNecessary() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.dequeueFuture == null || this.dequeueFuture.isDone()) {
                this.dequeueFuture = new CompletableFuture();
            }
            if (!this.isEmpty()) {
                try {
                    this.dequeueFuture.complete(this.dequeue());
                }
                catch (IOException e) {
                    this.dequeueFuture.completeExceptionally(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePeekFutureIfNecessary() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture == null || this.peekFuture.isDone()) {
                this.peekFuture = new CompletableFuture();
            }
            if (!this.isEmpty()) {
                try {
                    this.peekFuture.complete(this.peek());
                }
                catch (IOException e) {
                    this.peekFuture.completeExceptionally(e);
                }
            }
        }
    }
}

