/*
 * Decompiled with CFR 0.152.
 */
package org.juhewu.data.encrypt;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.juhewu.data.annotation.FieldEncrypt;
import org.juhewu.data.encrypt.IEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class EncryptionInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptionInterceptor.class);
    private final IEncryptor encryptor;

    public EncryptionInterceptor(IEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Object intercept(Invocation invocation) throws IllegalAccessException, InvocationTargetException {
        Object[] args = invocation.getArgs();
        SqlCommandType sqlCommandType = null;
        for (Object object : args) {
            if (object instanceof MappedStatement) {
                MappedStatement ms = (MappedStatement)object;
                sqlCommandType = ms.getSqlCommandType();
                continue;
            }
            if (SqlCommandType.INSERT != sqlCommandType && SqlCommandType.UPDATE != sqlCommandType) continue;
            this.encryptField(object);
        }
        return invocation.proceed();
    }

    private void encryptField(Object object) throws IllegalAccessException {
        Field[] fields;
        if (null == object) {
            return;
        }
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            FieldEncrypt encrypt = field.getAnnotation(FieldEncrypt.class);
            Object value = field.get(object);
            if (encrypt == null || value == null) continue;
            String encryptString = this.encryptor.encrypt(value.toString());
            field.set(object, encryptString);
            if (!log.isDebugEnabled()) continue;
            log.debug("\u6570\u636e\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7684\u5c5e\u6027\u4fe1\u606f: \u7c7b\u540d {}\uff0c\u5c5e\u6027\u540d {}", (Object)clazz.getSimpleName(), (Object)field.getName());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

