/*
 * Decompiled with CFR 0.152.
 */
package org.juhewu.data.encrypt;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.juhewu.data.annotation.FieldEncrypt;
import org.juhewu.data.encrypt.IEncryptor;
import org.juhewu.data.exception.DecryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DecryptionInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptionInterceptor.class);
    private final IEncryptor encryptor;
    private final boolean isSkipDecryptError;

    public DecryptionInterceptor(IEncryptor encryptor, boolean isSkipDecryptError) {
        this.encryptor = encryptor;
        this.isSkipDecryptError = isSkipDecryptError;
    }

    public Object intercept(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        Object result = invocation.proceed();
        if (result instanceof ArrayList) {
            ArrayList list = (ArrayList)result;
            if (list.isEmpty()) {
                return result;
            }
            for (Object item : list) {
                this.decryptField(item);
            }
            return result;
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    private void decryptField(Object object) throws IllegalAccessException {
        Field[] fields;
        if (null == object) {
            return;
        }
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            FieldEncrypt encrypt = field.getAnnotation(FieldEncrypt.class);
            Object value = field.get(object);
            if (encrypt == null || value == null) continue;
            try {
                String decryptString = this.encryptor.decrypt(value.toString());
                field.set(object, decryptString);
            }
            catch (Exception e) {
                if (!this.isSkipDecryptError) {
                    log.error("\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u89e3\u5bc6\u7684\u5c5e\u6027\u4fe1\u606f: \u7c7b\u540d {}\uff0c\u5c5e\u6027\u540d {}", (Object)clazz.getSimpleName(), (Object)field.getName());
                    throw new DecryptException("\u6570\u636e\u89e3\u5bc6\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
                }
                log.debug("\u6570\u636e\u89e3\u5bc6\u5931\u8d25\u8fd4\u56de\u6e90\u5b57\u7b26\uff0c\u89e3\u5bc6\u7684\u5c5e\u6027\u4fe1\u606f: \u7c7b\u540d {}\uff0c\u5c5e\u6027\u540d {}", (Object)clazz.getSimpleName(), (Object)field.getName());
                return;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("\u6570\u636e\u89e3\u5bc6\uff0c\u89e3\u5bc6\u7684\u5c5e\u6027\u4fe1\u606f: \u7c7b\u540d {}\uff0c\u5c5e\u6027\u540d {}", (Object)clazz.getSimpleName(), (Object)field.getName());
        }
    }
}

