/*
 * Decompiled with CFR 0.152.
 */
package org.juhewu.data.encrypt.config;

import org.juhewu.data.encrypt.DecryptionInterceptor;
import org.juhewu.data.encrypt.DefaultAesEncryptor;
import org.juhewu.data.encrypt.EncryptionInterceptor;
import org.juhewu.data.encrypt.IEncryptor;
import org.juhewu.data.encrypt.config.EncryptorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={EncryptorProperties.class})
@ConditionalOnProperty(prefix="juhewu.data.encrypt", value={"enable"}, havingValue="true")
public class EncryptAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EncryptAutoConfiguration.class);

    @Bean
    public IEncryptor defaultAesEncryptor(EncryptorProperties encryptorProperties) {
        log.debug("\u4f7f\u7528\u9ed8\u8ba4\u7684 aes \u7b97\u6cd5\u52a0\u89e3\u5bc6\u5b57\u6bb5\u5c5e\u6027\u7684\u503c");
        return new DefaultAesEncryptor(encryptorProperties.getPassword());
    }

    @Bean
    public DecryptionInterceptor decryptionInterceptor(IEncryptor encryptor, EncryptorProperties properties) {
        return new DecryptionInterceptor(encryptor, properties.isSkipDecryptError());
    }

    @Bean
    public EncryptionInterceptor encryptionInterceptor(IEncryptor encryptor) {
        return new EncryptionInterceptor(encryptor);
    }
}

