/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.ObjectFinder;
import org.jtransfo.ObjectReplacer;
import org.jtransfo.TypeConverter;
import org.jtransfo.cdi.InterceptorOrder;

@ApplicationScoped
public class JTransfoCdiFactory {
    @Inject
    private Instance<ObjectFinder> objectFinders;
    @Inject
    private Instance<TypeConverter<?, ?>> typeConverters;
    @Inject
    private Instance<ConvertInterceptor> convertInterceptors;
    @Inject
    private Instance<ObjectReplacer> objectReplacers;

    @Produces
    public JTransfo get() {
        ArrayList<Object> orderedInterceptors;
        ConfigurableJTransfo jTransfo = JTransfoFactory.get();
        if (null != this.typeConverters) {
            for (TypeConverter typeConverter : this.typeConverters) {
                jTransfo.getTypeConverters().add(typeConverter);
            }
            jTransfo.updateTypeConverters();
        }
        if (null != this.objectFinders) {
            for (ObjectFinder objectFinder : this.objectFinders) {
                jTransfo.getObjectFinders().add(objectFinder);
            }
            jTransfo.updateObjectFinders();
        }
        if (null != this.convertInterceptors) {
            orderedInterceptors = new ArrayList<Object>();
            for (ConvertInterceptor convertInterceptor : this.convertInterceptors) {
                orderedInterceptors.add(convertInterceptor);
            }
            Collections.sort(orderedInterceptors, new AnnotationAwareOrderComparator());
            jTransfo.getConvertInterceptors().addAll(orderedInterceptors);
            jTransfo.updateConvertInterceptors();
        }
        if (null != this.objectReplacers) {
            orderedInterceptors = new ArrayList();
            for (ObjectReplacer objectClassDeterminator : this.objectReplacers) {
                orderedInterceptors.add(objectClassDeterminator);
            }
            Collections.sort(orderedInterceptors, new AnnotationAwareOrderComparator());
            jTransfo.getObjectReplacers().addAll(orderedInterceptors);
            jTransfo.updateObjectReplacers();
        }
        return jTransfo;
    }

    private class AnnotationAwareOrderComparator
    implements Comparator<Object> {
        private AnnotationAwareOrderComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = this.getOrder(o1);
            return i1 < (i2 = this.getOrder(o2)) ? -1 : (i1 > i2 ? 1 : 0);
        }

        private int getOrder(Object obj) {
            InterceptorOrder order;
            if (obj != null && (order = obj.getClass().getAnnotation(InterceptorOrder.class)) != null) {
                return order.value();
            }
            return Integer.MAX_VALUE;
        }
    }
}

