/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.cdi;

import java.util.Date;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jtransfo.JTransfo;
import org.jtransfo.cdi.domain.PersonDomain;
import org.jtransfo.cdi.domain.PersonTo;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.object.Gender;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class JTransfoCdiFactoryCustomizedTest {
    private static final String NAME = "ikke";
    @Inject
    private JTransfo jTransfo;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage("org.jtransfo.cdi")).addPackage("org.jtransfo.cdi.domain")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    public void testWithFinderAndConverterAndInterceptorsToDomain() throws Exception {
        PersonTo to = new PersonTo();
        to.setGender("MALE");
        to.setLastChanged(new Date());
        to.setName(NAME);
        to.setAddress(new AddressTo(Long.valueOf(3L)));
        PersonDomain domain = (PersonDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Object)domain.getGender()).isEqualTo((Object)Gender.MALE);
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Date)domain.getLastChanged()).isNotNull();
        Assertions.assertThat((long)domain.getLastChanged().getTime()).isGreaterThan(System.currentTimeMillis() - 1000L);
        Assertions.assertThat((String)domain.getExtra()).isEqualTo((Object)"Extra sleep.");
    }

    @Test
    public void testWithFinderAndConverterToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        Date now = new Date();
        domain.setLastChanged(now);
        AddressDomain address = new AddressDomain();
        address.setId(Long.valueOf(7L));
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        PersonTo to = (PersonTo)this.jTransfo.convert((Object)domain, (Object)new PersonTo(), new String[0]);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
    }
}

