/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.cdi;

import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jtransfo.JTransfo;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class JTransfoCdiDefaultTest {
    @Inject
    private JTransfo jTransfo;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage("org.jtransfo.cdi")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    public void testToTo() throws Exception {
        SimpleExtendedDomain domain = new SimpleExtendedDomain();
        domain.setA("aaa");
        domain.setB("bb");
        domain.setC("cccc");
        domain.setI(111);
        SimpleExtendedTo res = new SimpleExtendedTo();
        this.jTransfo.convert((Object)domain, (Object)res, new String[0]);
        Assertions.assertThat((String)res.getA()).isEqualTo((Object)"aaa");
        Assertions.assertThat((String)res.getString()).isEqualTo((Object)"bb");
        Assertions.assertThat((String)res.getC()).isEqualTo((Object)"cccc");
        Assertions.assertThat((int)res.getI()).isEqualTo(111);
        Assertions.assertThat((int)res.getJ()).isEqualTo(0);
        Assertions.assertThat((int)res.getK()).isEqualTo(0);
    }

    @Test
    public void testToDomain() throws Exception {
        SimpleExtendedTo to = new SimpleExtendedTo();
        to.setA("aaa");
        to.setString("bb");
        to.setC("cccc");
        to.setI(111);
        to.setJ(22);
        to.setK(3333);
        SimpleExtendedDomain res = (SimpleExtendedDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((String)res.getA()).isEqualTo((Object)"aaa");
        Assertions.assertThat((String)res.getB()).isEqualTo((Object)"bb");
        Assertions.assertThat((String)res.getC()).isNull();
        Assertions.assertThat((int)res.getI()).isEqualTo(111);
    }
}

