/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.ObjectFinder;
import org.jtransfo.TypeConverter;
import org.jtransfo.cdi.InterceptorOrder;

@ApplicationScoped
public class JTransfoCdi
extends JTransfoImpl {
    @Inject
    private Instance<ObjectFinder> objectFinders;
    @Inject
    private Instance<TypeConverter<?, ?>> typeConverters;
    @Inject
    private Instance<ConvertInterceptor> convertInterceptors;

    @PostConstruct
    protected void postConstruct() {
        if (null != this.typeConverters) {
            for (TypeConverter typeConverter : this.typeConverters) {
                this.getTypeConverters().add(typeConverter);
            }
            this.updateTypeConverters();
        }
        if (null != this.objectFinders) {
            for (ObjectFinder objectFinder : this.objectFinders) {
                this.getObjectFinders().add(objectFinder);
            }
            this.updateObjectFinders();
        }
        if (null != this.convertInterceptors) {
            ArrayList<ConvertInterceptor> orderedInterceptors = new ArrayList<ConvertInterceptor>();
            for (ConvertInterceptor convertInterceptor : this.convertInterceptors) {
                orderedInterceptors.add(convertInterceptor);
            }
            Collections.sort(orderedInterceptors, new AnnotationAwareOrderComparator());
            this.getConvertInterceptors().addAll(orderedInterceptors);
            this.updateConvertInterceptors();
        }
    }

    private class AnnotationAwareOrderComparator
    implements Comparator<Object> {
        private AnnotationAwareOrderComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = this.getOrder(o1);
            return i1 < (i2 = this.getOrder(o2)) ? -1 : (i1 > i2 ? 1 : 0);
        }

        private int getOrder(Object obj) {
            InterceptorOrder order;
            if (obj != null && (order = obj.getClass().getAnnotation(InterceptorOrder.class)) != null) {
                return order.value();
            }
            return Integer.MAX_VALUE;
        }
    }
}

