/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.Upload;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.upload.ArtifactoryUploaderValidator;
import org.jreleaser.model.internal.validation.upload.FtpUploaderValidator;
import org.jreleaser.model.internal.validation.upload.GiteaUploaderValidator;
import org.jreleaser.model.internal.validation.upload.GitlabUploaderValidator;
import org.jreleaser.model.internal.validation.upload.HttpUploaderValidator;
import org.jreleaser.model.internal.validation.upload.S3UploaderValidator;
import org.jreleaser.model.internal.validation.upload.ScpUploaderValidator;
import org.jreleaser.model.internal.validation.upload.SftpUploaderValidator;
import org.jreleaser.util.Errors;

public abstract class UploadersValidator
extends Validator {
    public static void validateUploaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Upload upload = context.getModel().getUpload();
        context.getLogger().debug("upload");
        ArtifactoryUploaderValidator.validateArtifactory(context, mode, errors);
        FtpUploaderValidator.validateFtpUploader(context, mode, errors);
        GiteaUploaderValidator.validateGiteaUploader(context, mode, errors);
        GitlabUploaderValidator.validateGitlabUploader(context, mode, errors);
        HttpUploaderValidator.validateHttpUploader(context, mode, errors);
        S3UploaderValidator.validateS3(context, mode, errors);
        ScpUploaderValidator.validateScpUploader(context, mode, errors);
        SftpUploaderValidator.validateSftpUploader(context, mode, errors);
        if (mode.validateConfig()) {
            boolean activeSet = upload.isActiveSet();
            upload.resolveEnabled(context.getModel().getProject());
            if (upload.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = !upload.getActiveArtifactories().isEmpty() || !upload.getActiveFtps().isEmpty() || !upload.getActiveGiteas().isEmpty() || !upload.getActiveGitlabs().isEmpty() || !upload.getActiveHttps().isEmpty() || !upload.getActiveS3s().isEmpty() || !upload.getActiveScps().isEmpty() || !upload.getActiveSftps().isEmpty();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    upload.disable();
                }
            }
        }
    }
}

