/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.internal.announce.WebhooksAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class WebhooksAnnouncerValidator
extends Validator {
    private static final String DEFAULT_TPL = "src/jreleaser/templates/";

    public static void validateWebhooks(JReleaserContext context, JReleaserContext.Mode mode, WebhooksAnnouncer webhooks, Errors errors) {
        context.getLogger().debug("announce.webhooks");
        Map<String, WebhookAnnouncer> webhook = webhooks.getWebhooks();
        boolean enabled = false;
        for (Map.Entry<String, WebhookAnnouncer> e : webhook.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAnnounce() || !WebhooksAnnouncerValidator.validateWebhook(context, webhooks, e.getValue(), errors)) continue;
            enabled = true;
        }
        if (enabled) {
            webhooks.setActive(Active.ALWAYS);
        } else {
            webhooks.setActive(Active.NEVER);
        }
        if (!webhooks.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
        }
    }

    public static boolean validateWebhook(JReleaserContext context, WebhooksAnnouncer webhooks, WebhookAnnouncer webhook, Errors errors) {
        context.getLogger().debug("announce.webhook." + webhook.getName());
        if (!webhook.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((String)webhook.getName())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            webhook.disable();
            return false;
        }
        webhook.setWebhook(WebhooksAnnouncerValidator.checkProperty(context, Env.toVar((String)webhook.getName()) + "_WEBHOOK", "webhook." + webhook.getName() + ".webhook", webhook.getWebhook(), errors, context.isDryrun()));
        String defaultMessageTemplate = DEFAULT_TPL + webhook.getName() + ".tpl";
        if (StringUtils.isBlank((String)webhook.getMessage()) && StringUtils.isBlank((String)webhook.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(defaultMessageTemplate), new LinkOption[0])) {
                webhook.setMessageTemplate(defaultMessageTemplate);
            } else {
                webhook.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)webhook.getMessage()) && StringUtils.isBlank((String)webhook.getMessageProperty())) {
            webhook.setMessageProperty("text");
        }
        if (StringUtils.isNotBlank((String)webhook.getMessageTemplate()) && !defaultMessageTemplate.equals(webhook.getMessageTemplate().trim()) && !Files.exists(context.getBasedir().resolve(webhook.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"webhook." + webhook.getName() + ".messageTemplate", webhook.getMessageTemplate()}));
        }
        WebhooksAnnouncerValidator.validateTimeout(webhook);
        return true;
    }
}

