/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public abstract class AbstractRepositoryTap<S extends AbstractRepositoryTap<S>>
extends AbstractModelObject<S>
implements RepositoryTap {
    protected Active active;
    @JsonIgnore
    protected boolean enabled;
    @JsonIgnore
    protected String basename;
    @JsonIgnore
    protected String tapName;
    protected String owner;
    protected String name;
    protected String tagName;
    protected String branch;
    protected String username;
    protected String token;
    protected String commitMessage;

    public AbstractRepositoryTap(String basename, String tapName) {
        this.basename = basename;
        this.tapName = tapName;
    }

    @Override
    public String getBasename() {
        return this.basename;
    }

    public void setTapName(String tapName) {
        this.tapName = tapName;
    }

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractRepositoryTap)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractRepositoryTap)source).enabled);
        this.owner = this.merge(this.owner, ((AbstractRepositoryTap)source).owner);
        this.name = this.merge(this.name, ((AbstractRepositoryTap)source).name);
        this.tagName = this.merge(this.tagName, ((AbstractRepositoryTap)source).tagName);
        this.branch = this.merge(this.branch, ((AbstractRepositoryTap)source).branch);
        this.username = this.merge(this.username, ((AbstractRepositoryTap)source).username);
        this.token = this.merge(this.token, ((AbstractRepositoryTap)source).token);
        this.commitMessage = this.merge(this.commitMessage, ((AbstractRepositoryTap)source).commitMessage);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.RELEASE;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getCanonicalRepoName() {
        return this.owner + "/" + this.getResolvedName();
    }

    @Override
    public String getResolvedName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return this.name;
        }
        return this.tapName;
    }

    @Override
    public String getResolvedCommitMessage(Map<String, Object> props) {
        return Templates.resolveTemplate((String)this.commitMessage, props);
    }

    @Override
    public String getResolvedTagName(Map<String, Object> props) {
        return Templates.resolveTemplate((String)this.tagName, props);
    }

    @Override
    public String getResolvedUsername(BaseReleaser service) {
        return Env.env((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_USERNAME"), (String)this.username);
    }

    @Override
    public String getResolvedToken(BaseReleaser service) {
        return Env.env((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_TOKEN"), (String)this.token);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        map.put("owner", this.owner);
        map.put("name", this.getResolvedName());
        map.put("tagName", this.tagName);
        map.put("branch", this.branch);
        map.put("username", this.username);
        map.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        map.put("commitMessage", this.commitMessage);
        return map;
    }
}

