/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;

public final class Hooks
extends AbstractModelObject<Hooks>
implements Domain,
Activatable {
    private final CommandHooks command = new CommandHooks();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.hooks.Hooks immutable = new org.jreleaser.model.api.hooks.Hooks(){

        public org.jreleaser.model.api.hooks.CommandHooks getCommand() {
            return Hooks.this.command.asImmutable();
        }

        public Active getActive() {
            return Hooks.this.active;
        }

        public boolean isEnabled() {
            return Hooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Hooks.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.hooks.Hooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Hooks source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setCommand(source.command);
    }

    public boolean isSet() {
        return this.command.isSet();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"hooks.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public CommandHooks getCommand() {
        return this.command;
    }

    public void setCommand(CommandHooks command) {
        this.command.merge(command);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        map.put("command", this.command.asMap(full));
        return map;
    }
}

